/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.mtj.core.Messages;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.osgi.service.datalocation.Location;

public class Utils {
    private static final String PRIVATE_CONFIGURATION = "org.eclipse.debug.ui.private";
    private static final byte[] buffer = new byte[1024];
    private static boolean caseSensitivityChecked;
    private static boolean caseSensitiveFileSystem;

    public static boolean arePathTargetsEqual(IPath path1, IPath path2) {
        boolean equal = false;
        File file1 = Utils.getPathTargetFile(path1);
        File file2 = Utils.getPathTargetFile(path2);
        if (file1 != null && file2 != null) {
            equal = file1.equals(file2);
        }
        return equal;
    }

    public static void copyFile(IFile sourceFile, IFile targetFile) throws IOException {
        Utils.copyFile(sourceFile.getLocation().toFile(), targetFile.getLocation().toFile());
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        FileInputStream fis = new FileInputStream(sourceFile);
        FileOutputStream fos = new FileOutputStream(targetFile);
        Utils.copyInputToOutput(fis, fos);
        fis.close();
        fos.close();
    }

    public static void copyInputToOutput(InputStream input, OutputStream output) throws IOException {
        int bytesRead = 0;
        do {
            if ((bytesRead = input.read(buffer, 0, buffer.length)) <= 0) continue;
            output.write(buffer, 0, bytesRead);
        } while (bytesRead != -1);
        output.flush();
    }

    public static void dumpCommandLine(ILaunch launch) {
        IProcess process;
        IProcess[] processes = launch.getProcesses();
        if (processes != null && processes.length > 0 && (process = processes[0]) != null) {
            String commandLine = process.getAttribute(IProcess.ATTR_CMDLINE);
            Utils.dumpCommandLine(commandLine);
        }
    }

    public static void dumpCommandLine(String commandLine) {
        String propValue = System.getProperty("eclipseme.dump.launch", "false");
        boolean doDump = propValue.equalsIgnoreCase("TRUE");
        if (doDump) {
            String text = commandLine == null ? Messages.Utils_CommandLineNotFound : String.valueOf(Messages.Utils_CommandLine) + commandLine;
            MtjCorePlugin.log(1, text);
        }
    }

    public static void dumpCommandLine(String[] commandLine) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            String string = commandLine[i];
            if (i != 0) {
                sb.append(' ');
            }
            sb.append(string);
            ++i;
        }
        Utils.dumpCommandLine(sb.toString());
    }

    public static Process exec(String[] commandLine, File workingDirectory, String[] env) throws CoreException {
        return DebugPlugin.exec((String[])commandLine, (File)workingDirectory, (String[])env);
    }

    public static boolean executableExists(File executableFile) {
        File winExecutable = new File(executableFile.getParentFile(), String.valueOf(executableFile.getName()) + ".exe");
        return executableFile.exists() || winExecutable.exists();
    }

    public static ILaunch getNewLaunch(String configName) throws CoreException {
        return new Launch(Utils.getNewLaunchConfiguration(configName), "run", null);
    }

    public static ILaunchConfiguration getNewLaunchConfiguration(String name) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy config = configType.newInstance(null, name);
        config.setAttribute(PRIVATE_CONFIGURATION, true);
        return config;
    }

    public static Object getPathTarget(IPath path) {
        IWorkspaceRoot root = MtjCorePlugin.getWorkspace().getRoot();
        return JavaModel.getTarget((IContainer)root, (IPath)path, (boolean)true);
    }

    public static File getPathTargetFile(IPath path) {
        File entryFile = null;
        Object pathTarget = Utils.getPathTarget(path);
        if (pathTarget instanceof IResource) {
            entryFile = ((IResource)pathTarget).getLocation().toFile();
        } else if (pathTarget instanceof File) {
            entryFile = (File)pathTarget;
        }
        return entryFile;
    }

    public static String getQualifiedClassName(IType type) {
        String classname = null;
        classname = type instanceof BinaryType ? Utils.getQualifiedClassName((BinaryType)type) : type.getFullyQualifiedName();
        return classname;
    }

    public static Object getResolvedClasspathEntry(IClasspathEntry entry) {
        IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        return Utils.getPathTarget(resolved.getPath());
    }

    public static final File getResolvedClasspathEntryFile(IClasspathEntry entry) {
        IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        return Utils.getPathTargetFile(resolved.getPath());
    }

    public static String getStandardOutput(String name, String[] commandLine) throws CoreException {
        IProcess process = Utils.launchApplication(commandLine, null, null, name, name);
        IStreamsProxy proxy = process.getStreamsProxy();
        while (!process.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return proxy.getOutputStreamMonitor().getContents();
    }

    public static boolean isFileSystemCaseSensitive() {
        if (!caseSensitivityChecked) {
            String urlString;
            URL url;
            caseSensitivityChecked = true;
            Location location = Platform.getInstallLocation();
            if (location != null && (url = location.getURL()) != null && (urlString = url.toString()).startsWith("file:/")) {
                caseSensitiveFileSystem = !new File(urlString = urlString.substring("file:/".length()).toUpperCase()).exists();
            }
        }
        return caseSensitiveFileSystem;
    }

    public static boolean isMidlet(IType type, IProgressMonitor monitor) throws JavaModelException {
        boolean isMidlet = false;
        if (type != null) {
            IJavaProject javaProject = type.getJavaProject();
            if (!type.exists() && type.isBinary()) {
                String classname = Utils.getQualifiedClassName(type);
                if (classname != null) {
                    IType sourceType = javaProject.findType(classname);
                    isMidlet = Utils.isMidlet(sourceType, monitor);
                }
            } else {
                ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(monitor);
                IType midletType = javaProject.findType("javax.microedition.midlet.MIDlet");
                isMidlet = midletType != null && typeHierarchy.contains(midletType);
            }
        }
        return isMidlet;
    }

    public static IProcess launchApplication(String[] commandLine, File workingDirectory, String[] environment, String configName, String label) throws CoreException {
        Process execProcess = Utils.exec(commandLine, workingDirectory, environment);
        Launch launch = new Launch(Utils.getNewLaunchConfiguration(configName), "run", null);
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)execProcess, (String)label);
        Utils.dumpCommandLine(commandLine);
        return process;
    }

    private Utils() {
    }

    private static String getQualifiedClassName(BinaryType type) {
        IPackageFragment javaElement = type.getPackageFragment();
        StringBuffer name = new StringBuffer(type.getElementName());
        while (javaElement.getElementType() != 2) {
            String elementName = javaElement.getElementName();
            if (elementName != null && elementName.length() > 0) {
                name.insert(0, '.').insert(0, elementName);
            }
            javaElement = javaElement.getParent();
        }
        return name.toString();
    }
}

