/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dpp.impl;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.ConfigurationItem;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.PersistentStoreProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.IExecutablePlatform;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.launching.EmulatorRunner;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.MtjNotFoundException;
import org.eclipse.mtj.executable.uei.UeiExecutable;
import org.eclipse.mtj.extension.dm.preferences.DmPreferencePage;
import org.eclipse.mtj.extension.dpp.DevicePlatformPlugin;
import org.eclipse.mtj.extension.dpp.Messages;

public class DevicePlatformProviderImpl
extends MtjExtensionImpl
implements DevicePlatformProvider {
    private static DevicePlatformProviderImpl instance;

    public static DevicePlatformProviderImpl getDefault() {
        return instance;
    }

    public DevicePlatformProviderImpl() {
        instance = this;
        this.setId(DevicePlatformPlugin.getDefault().getBundle().getSymbolicName());
        this.setDescription(Messages.DevicePlatformProviderImpl_PluginDescription);
        this.setVendor(Messages.DevicePlatformProviderImpl_PluginVendor);
        this.setVersion(Messages.DevicePlatformProviderImpl_PluginVersion);
        this.setType(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL);
    }

    public void setDevicePlatform(DevicePlatform devicePlatform) throws MtjException {
        try {
            this.setAbsoluteFilePaths(devicePlatform);
            PersistentStoreProvider pstore = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
            pstore.store((Object)devicePlatform, 0, "devices", "org.eclipse.mtj.extension.dpp", "DevicePlatform");
            this.setRelativeFilePaths(devicePlatform);
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
    }

    public DevicePlatform[] getDevicePlatforms() throws MtjException {
        try {
            PersistentStoreProvider pstore = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
            EList list = null;
            try {
                list = (EList)pstore.get(0, "devices", "org.eclipse.mtj.extension.dpp", "DevicePlatform");
            }
            catch (MtjNotFoundException mtjNotFoundException) {
                return new DevicePlatform[0];
            }
            DevicePlatform devicePlatform = (DevicePlatform)list.get(0);
            this.setRelativeFilePaths(devicePlatform);
            devicePlatform.setDevicePlatformProvider((MtjExtension)this);
            DevicePlatform[] devicePlatforms = new DevicePlatform[]{devicePlatform};
            return devicePlatforms;
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
    }

    public void verify(IFolder sourceFolder, IProgressMonitor monitor) throws MtjException {
    }

    public void launch(DevicePlatform dp, Device device, Deployment deployment, VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, ILaunch launch, String runMode, String projectNatureId, IProgressMonitor monitor) throws MtjException {
        UeiExecutable executablePlatform = new UeiExecutable(this.getDevicePlatforms()[0], device);
        EmulatorRunner emulatorRunner = new EmulatorRunner(this.getDevicePlatforms()[0], (IExecutablePlatform)executablePlatform, runMode);
        try {
            emulatorRunner.run(vmRunnerConfig, launchConfig, deployment, launch, projectNatureId, device, monitor);
        }
        catch (CoreException e) {
            throw new MtjException((Throwable)e);
        }
        catch (MtjException e) {
            throw e;
        }
    }

    private void setRelativeFilePaths(DevicePlatform dp) throws MtjException {
        String root = this.getRootDirectory(dp);
        for (RuntimePlatformDefinition rpd : dp.getRuntimePlatformDefinitions()) {
            ImplementationRef ir;
            for (DeviceProfile dep : rpd.getDeviceProfiles()) {
                for (ServiceApi sa : dep.getServiceApis()) {
                    ImplementationRef ir2 = sa.getImplementation();
                    this.setRelativeFilePaths(ir2, root);
                }
            }
            for (ServiceApi sa : rpd.getServiceApis()) {
                ir = sa.getImplementation();
                this.setRelativeFilePaths(ir, root);
            }
            for (DeviceConfiguration dc : rpd.getDeviceConfigurations()) {
                ir = dc.getImplementation();
                this.setRelativeFilePaths(ir, root);
            }
        }
    }

    private void setRelativeFilePaths(ImplementationRef ir, String root) throws MtjException {
        ir.setFileRef(this.setRelativeFilePaths(ir.getFileRef(), root));
        ir.setJavadocRef(this.setRelativeFilePaths(ir.getJavadocRef(), root));
        ir.setSourceRef(this.setRelativeFilePaths(ir.getSourceRef(), root));
    }

    private String setRelativeFilePaths(String path, String root) throws MtjException {
        if (path == null) {
            return path;
        }
        String r = path.replace('\\', '/');
        if (r.startsWith("/")) {
            r = String.valueOf(root) + r;
        }
        return r;
    }

    private void setAbsoluteFilePaths(DevicePlatform dp) throws MtjException {
        String root = this.getRootDirectory(dp);
        for (RuntimePlatformDefinition rpd : dp.getRuntimePlatformDefinitions()) {
            ImplementationRef ir;
            for (DeviceProfile dep : rpd.getDeviceProfiles()) {
                for (ServiceApi sa : dep.getServiceApis()) {
                    ImplementationRef ir2 = sa.getImplementation();
                    this.setAbsoluteFilePaths(ir2, root);
                }
            }
            for (ServiceApi sa : rpd.getServiceApis()) {
                ir = sa.getImplementation();
                this.setAbsoluteFilePaths(ir, root);
            }
            for (DeviceConfiguration dc : rpd.getDeviceConfigurations()) {
                ir = dc.getImplementation();
                this.setAbsoluteFilePaths(ir, root);
            }
        }
    }

    private void setAbsoluteFilePaths(ImplementationRef ir, String root) throws MtjException {
        ir.setFileRef(this.setAbsoluteFilePaths(ir.getFileRef(), root));
        ir.setJavadocRef(this.setAbsoluteFilePaths(ir.getJavadocRef(), root));
        ir.setSourceRef(this.setAbsoluteFilePaths(ir.getSourceRef(), root));
    }

    private String setAbsoluteFilePaths(String path, String root) throws MtjException {
        if (path == null) {
            return path;
        }
        String r = path.replace('\\', '/');
        if (r.startsWith(root)) {
            r = r.substring(root.length());
        }
        return r;
    }

    public String getRootDirectory(DevicePlatform dp) throws MtjException {
        for (ConfigurationItem item : dp.getConfiguration().getItems()) {
            String d;
            if (!"directory".equals(item.getName()) || (d = item.getValue()) == null) continue;
            if ((d = d.replace('\\', '/')).endsWith("/")) {
                d = d.substring(0, d.length() - 1);
            }
            return d;
        }
        throw new MtjException(Messages.DevicePlatformProviderImpl_RootDirectoryNotDefined);
    }

    public DeviceStatus getStatus(Device device) throws MtjException {
        for (Device d : this.getDevicePlatforms()[0].getDevices()) {
            if (d.getName() == null || !d.getName().equals(device.getName())) continue;
            return DeviceStatus.DEVICE_STATUS_OK_LITERAL;
        }
        return DeviceStatus.DEVICE_STATUS_ERROR_LITERAL;
    }

    public PreferencePage getPreferencePage() {
        return new DmPreferencePage();
    }
}

