/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.jadeditor;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.extension.devide.jadeditor.JADMidletsEditorPage;
import org.eclipse.mtj.extension.devide.jadeditor.JADOTAPropertiesEditorPage;
import org.eclipse.mtj.extension.devide.jadeditor.JADOptionalPropertiesEditorPage;
import org.eclipse.mtj.extension.devide.jadeditor.JADRequiredPropertiesEditorPage;
import org.eclipse.mtj.extension.devide.jadeditor.JADUserDefinedPropertiesEditorPage;
import org.eclipse.mtj.extension.devide.jadeditor.JadEditorStrings;
import org.eclipse.mtj.extension.devide.jadeditor.ManifestPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;

public class JADEditor
extends FormEditor {
    private ManifestPreferenceStore preferenceStore;
    private IFile jadFile;
    private long modificationStamp;
    private JADRequiredPropertiesEditorPage requiredPropertiesEditorPage;
    private JADMidletsEditorPage midletsEditorPage;
    private JADOptionalPropertiesEditorPage optionalPropertiesEditorPage;
    private JADOTAPropertiesEditorPage otaPropertiesEditorPage;
    private JADUserDefinedPropertiesEditorPage userDefinedPropertiesEditorPage;

    protected void addPages() {
        try {
            String title = JadEditorStrings.editor_jad_tab_required_properties;
            this.requiredPropertiesEditorPage = new JADRequiredPropertiesEditorPage(this);
            this.addPage((IFormPage)this.requiredPropertiesEditorPage);
            title = JadEditorStrings.editor_jad_tab_midlets;
            this.midletsEditorPage = new JADMidletsEditorPage(this, title);
            this.addPage((IFormPage)this.midletsEditorPage);
            title = JadEditorStrings.editor_jad_tab_optional_properties;
            this.optionalPropertiesEditorPage = new JADOptionalPropertiesEditorPage(this);
            this.addPage((IFormPage)this.optionalPropertiesEditorPage);
            title = JadEditorStrings.editor_jad_tab_ota;
            this.otaPropertiesEditorPage = new JADOTAPropertiesEditorPage(this);
            this.addPage((IFormPage)this.otaPropertiesEditorPage);
            title = JadEditorStrings.editor_jad_tab_user_defined_properties;
            this.userDefinedPropertiesEditorPage = new JADUserDefinedPropertiesEditorPage(this, title);
            this.addPage((IFormPage)this.userDefinedPropertiesEditorPage);
        }
        catch (PartInitException e) {
            MtjCorePlugin.log((int)4, (Throwable)e);
        }
    }

    public boolean isDirty() {
        boolean dirty = false;
        for (IFormPage formPage : this.pages) {
            if (formPage == null || formPage.getPartControl() == null || !formPage.isDirty()) continue;
            dirty = true;
            break;
        }
        return dirty;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask("", this.getPageCount() + 1);
        int i = 0;
        for (IFormPage formPage : this.pages) {
            if (formPage != null && formPage.getPartControl() != null && formPage.isDirty()) {
                formPage.doSave(monitor);
            }
            monitor.worked(i + 1);
        }
        try {
            this.preferenceStore.save();
            if (this.jadFile != null && this.jadFile.exists()) {
                this.jadFile.refreshLocal(0, monitor);
            }
        }
        catch (IOException e) {
            MtjCorePlugin.log((int)4, (Throwable)e);
        }
        catch (CoreException e) {
            MtjCorePlugin.log((int)4, (Throwable)e);
        }
        monitor.done();
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
    }

    public ManifestPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        if (this.jadFile != null && this.jadFile.getModificationStamp() > this.modificationStamp && this.shouldReloadFile()) {
            this.updateEditorInput();
            this.requiredPropertiesEditorPage.editorInputChanged();
            this.optionalPropertiesEditorPage.editorInputChanged();
            this.otaPropertiesEditorPage.editorInputChanged();
            this.midletsEditorPage.editorInputChanged();
            this.userDefinedPropertiesEditorPage.editorInputChanged();
        }
        super.setFocus();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof IStorageEditorInput) {
            IStorageEditorInput storageInput = (IStorageEditorInput)input;
            try {
                IPath storagePath = storageInput.getStorage().getFullPath();
                if (storagePath != null) {
                    IWorkspaceRoot root = MtjCorePlugin.getWorkspace().getRoot();
                    this.jadFile = root.getFile(storagePath.makeAbsolute());
                    if (this.jadFile != null && this.jadFile.exists()) {
                        this.updateEditorInput();
                    }
                }
            }
            catch (Exception e) {
                MtjCorePlugin.log((int)2, (Throwable)e);
            }
        }
    }

    boolean isUserDefinedPropertyKey(String key) {
        return !this.requiredPropertiesEditorPage.isManagingProperty(key) && !this.optionalPropertiesEditorPage.isManagingProperty(key) && !this.otaPropertiesEditorPage.isManagingProperty(key) && !this.midletsEditorPage.isManagingProperty(key);
    }

    private boolean shouldReloadFile() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"File Updated", (String)"The file has been updated.  Would you like to reload?");
    }

    private void updateEditorInput() {
        this.modificationStamp = this.jadFile.getModificationStamp();
        String filename = this.jadFile.getLocation().toOSString();
        this.preferenceStore = new ManifestPreferenceStore(filename);
        try {
            this.preferenceStore.load();
        }
        catch (IOException e) {
            MtjCorePlugin.log((int)2, (Throwable)e);
        }
    }
}

