/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.MtjUIErrorResources;

public class MtjCoreErrors {
    public static final String MESSAGE_PREFIX = "MTJCoreError.";
    public static final int ERROR_BASE_CORE = 512;
    public static final int ERROR_BASE_PACKAGING = 1024;
    public static final int ERROR_BASE_BUILD = 1536;
    public static final int ERROR_BASE_LAUNCH = 2048;
    public static final int ERROR_BASE_PROJECT = 2560;
    public static final int ERROR_BASE_DEVICE_PLATFORM = 3072;
    public static final int ERROR_BASE_SIGNING = 3584;
    public static final int ERROR_BASE_PREVERIFICATION = 10000;
    public static final int ERROR_BASE_SECURITY = 20000;
    public static final int EMF_DATA_MODEL_ERROR = 513;
    public static final int PACKAGING_PROVIDER_NOT_FOUND_ERROR = 1025;
    public static final int PACKAGING_ERROR = 1026;
    public static final int BUILD_PROVIDER_NOT_FOUND_ERROR = 1537;
    public static final int VM_CONNECT_TIMEOUT_ERROR = 2049;
    public static final int TARGET_DEVICE_ACCESS_ERROR = 2050;
    public static final int TARGET_PLATFORM_ACCESS_ERROR = 2051;
    public static final int MIDP_JAD_CREATION_ERROR = 2052;
    public static final int PROJECT_DEPLOYMENT_ACCESS_ERROR = 2561;
    public static final int PROJECT_INSTANTIATION_ERROR = 2562;
    public static final int PROJECT_EXTENSION_DATA_ERROR = 2563;
    public static final int DEVICE_PLATFORM_PROVIDER_NOT_DEFINED_ERROR = 3073;
    public static final int DEVICE_PLATFORM_ROOT_ERROR = 3074;
    public static final int SIGNING_BAD_KEYSTORE_OR_PASSWORD = 3585;
    public static final int SIGNING_KEYSTORE_TYPE_NOT_AVAILABLE = 3586;
    public static final int SIGNING_PROVIDER_NOT_CONFIGURED = 3587;
    public static final int SIGNING_MISSING_KEYSTORE_INTEGRITY_ALGORITHM = 3588;
    public static final int SIGNING_COULDNT_LOAD_CERTIFICATE = 3589;
    public static final int SIGNING_KEY_NOT_FOUND = 3590;
    public static final int SIGNING_INVALID_KEY_PASSWORD = 3591;
    public static final int SIGNING_BAD_KEY_TYPE = 3592;
    public static final int SIGNING_INVALID_CERTIFICATE_CHAIN = 3593;
    public static final int SIGNING_MISSING_CERTIFICATES = 3594;
    public static final int SIGNING_INVALID_KEY = 3595;
    public static final int SIGNING_NO_SUCH_ALGORITHM = 3596;
    public static final int SIGNING_SIGNATURE_EXCEPTION = 3597;
    public static final int SIGNING_CERTIFICATE_ENCODING = 3598;
    public static final int SIGNING_DEPLOYMENT_NOT_SUPPORTED = 3599;
    public static final int SIGNING_KEYSOTRE_NOT_FOUND = 3600;
    public static final int SECURITY_BAD_KEYSTORE_OR_PASSWORD = 20001;
    public static final int SECURITY_BAD_KEY_TYPE = 20002;
    public static final int SECURITY_MANAGER_NOT_CONFIGURED = 20003;
    public static final int SECURITY_ALIAS_DUPLICATE = 20004;
    public static final int SECURITY_MALFORMED_PASSWORD = 20005;
    public static final int PREVERIFICATION_ERROR = 10001;
    public static final int PREVERIFICATION_PROVIDER_NOT_FOUND_ERROR = 10002;
    public static final int ERRORS_FOUND_IN_PREVERIFICATION = 10003;
    public static final int ERROR_WHILE_ADDING_PREVERIFICATION_ERRORS = 10004;
    public static final int CORE_WARNING_BASE = 20000;
    public static final int CORE_INTERNAL_BASE = 90000;
    public static final int SIGNING_INTERNAL_MISSING_KEYCHAINSET = 90001;
    public static final int SIGNING_INTERNAL_UNABLE_TO_BUILD_KEYRING_URL = 90002;

    public static final String getErrorMessage(int nCode) {
        String strTemplate = MtjUIErrorResources.getString(MESSAGE_PREFIX + nCode);
        if (strTemplate == null) {
            strTemplate = nCode < 90000 ? MtjUIErrorResources.getString("MTJCoreError.Default") : MtjUIErrorResources.getString("MTJCoreError.InternalTemplate");
        }
        String strMessage = MessageFormat.format(strTemplate, new Integer(nCode));
        return strMessage;
    }

    public static void throwCoreExceptionError(int code) throws CoreException {
        Status status = new Status(4, "org.eclipse.mtj.core", code, MtjCoreErrors.getErrorMessage(code), null);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreExceptionError(int code, Throwable e) throws CoreException {
        Status status = new Status(4, "org.eclipse.mtj.core", code, MtjCoreErrors.getErrorMessage(code), e);
        throw new CoreException((IStatus)status);
    }
}

