/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.internal.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;

public class ColonDelimitedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    public ColonDelimitedProperties() {
    }

    public ColonDelimitedProperties(Properties defaults) {
        super(defaults);
    }

    public synchronized void load(InputStream inStream) throws IOException {
        InputStreamReader dataReader = new InputStreamReader(inStream);
        this.load(dataReader);
    }

    public synchronized void load(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            int colonIndex;
            if ((line = line.trim()).length() <= 0 || line.startsWith("#") || (colonIndex = line.indexOf(58)) == -1) continue;
            String name = line.substring(0, colonIndex);
            if (colonIndex + 2 >= line.length()) continue;
            String value = line.substring(colonIndex + 2);
            this.setProperty(name, value);
        }
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            writer.println(entry.getKey() + ": " + entry.getValue());
        }
        writer.flush();
    }
}

