/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.builder;

import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MtjBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.mtj.extension.MtjDevIde.mtjBuilder";
    private static final String MARKER_TYPE = "org.eclipse.mtj.extension.MtjDevIde.xmlProblem";
    private SAXParserFactory parserFactory;

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException coreException) {}
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    void checkXML(IResource resource) {
        if (resource instanceof IFile && resource.getName().endsWith(".xml")) {
            IFile file = (IFile)resource;
            this.deleteMarkers(file);
            XMLErrorHandler reporter = new XMLErrorHandler(file);
            try {
                this.getParser().parse(file.getContents(), (DefaultHandler)reporter);
            }
            catch (Exception exception) {}
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {}
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new SampleResourceVisitor());
        }
        catch (CoreException coreException) {}
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.parserFactory == null) {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        return this.parserFactory.newSAXParser();
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    MtjBuilder.this.checkXML(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    MtjBuilder.this.checkXML(resource);
                }
            }
            return true;
        }
    }

    class SampleResourceVisitor
    implements IResourceVisitor {
        SampleResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            MtjBuilder.this.checkXML(resource);
            return true;
        }
    }

    class XMLErrorHandler
    extends DefaultHandler {
        private IFile file;

        public XMLErrorHandler(IFile file) {
            this.file = file;
        }

        private void addMarker(SAXParseException e, int severity) {
            MtjBuilder.this.addMarker(this.file, e.getMessage(), e.getLineNumber(), severity);
        }

        public void error(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 1);
        }
    }
}

