/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.extension.devide.utils.IClasspathEntryVisitor;

public class ClasspathEntryVisitorRunner {
    private boolean breadthFirst;

    public ClasspathEntryVisitorRunner() {
        this(false);
    }

    public ClasspathEntryVisitorRunner(boolean breadthFirst) {
        this.breadthFirst = breadthFirst;
    }

    public void run(IJavaProject javaProject, IClasspathEntryVisitor entryVisitor, String natureId, IProgressMonitor monitor) throws CoreException {
        if (javaProject != null) {
            ArrayList breadthFirstProjects = new ArrayList();
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                this.visitEntry(javaProject, entry, entryVisitor, breadthFirstProjects, natureId, monitor);
                ++i;
            }
            for (IJavaProject jProject : breadthFirstProjects) {
                this.run(jProject, entryVisitor, natureId, monitor);
            }
        }
    }

    private void visitEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, ArrayList breadthFirstProjects, String natureId, IProgressMonitor monitor) throws CoreException {
        switch (entry.getEntryKind()) {
            case 5: {
                this.visitContainerEntry(javaProject, entry, entryVisitor, breadthFirstProjects, natureId, monitor);
                break;
            }
            case 1: {
                this.visitLibraryEntry(javaProject, entry, entryVisitor, monitor);
                break;
            }
            case 2: {
                this.visitProjectEntry(javaProject, entry, entryVisitor, breadthFirstProjects, natureId, monitor);
                break;
            }
            case 3: {
                this.visitSourceEntry(javaProject, entry, entryVisitor, monitor);
                break;
            }
            case 4: {
                this.visitVariableEntry(javaProject, entry, entryVisitor, breadthFirstProjects, natureId, monitor);
            }
        }
    }

    private void visitContainerEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, ArrayList breadthFirstProjects, String natureId, IProgressMonitor monitor) throws CoreException {
        IPath containerPath = entry.getPath();
        if (entryVisitor.visitContainer(entry, javaProject, containerPath.lastSegment(), monitor)) {
            IClasspathContainer cpContainer = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject);
            IClasspathEntry[] entries = cpContainer.getClasspathEntries();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry2 = entries[i];
                this.visitEntry(javaProject, entry2, entryVisitor, breadthFirstProjects, natureId, monitor);
                ++i;
            }
        }
    }

    private void visitLibraryEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        entryVisitor.visitLibraryEntry(entry, javaProject, monitor);
    }

    private void visitProjectEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, ArrayList breadthFirstProjects, String natureId, IProgressMonitor monitor) throws CoreException {
        IPath projectPath = entry.getPath();
        IProject project = (IProject)MtjCorePlugin.getWorkspace().getRoot().findMember(projectPath);
        IJavaProject jProject = JavaCore.create((IProject)project);
        if (entryVisitor.visitProject(entry, javaProject, jProject, natureId, monitor)) {
            if (this.breadthFirst) {
                breadthFirstProjects.add(jProject);
            } else {
                this.run(jProject, entryVisitor, natureId, monitor);
            }
        }
    }

    private void visitSourceEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, IProgressMonitor monitor) throws CoreException {
        entryVisitor.visitSourceEntry(entry, javaProject, monitor);
    }

    private void visitVariableEntry(IJavaProject javaProject, IClasspathEntry entry, IClasspathEntryVisitor entryVisitor, ArrayList breadthFirstProjects, String natureId, IProgressMonitor monitor) throws CoreException {
        String variableName = entry.getPath().lastSegment();
        if (entryVisitor.visitVariable(entry, javaProject, variableName, monitor)) {
            IClasspathEntry entry2 = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
            this.visitEntry(javaProject, entry2, entryVisitor, breadthFirstProjects, natureId, monitor);
        }
    }
}

