/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.preverify.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mtj.api.model.preverifier.IClassErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IFieldErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IMethodErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.eclipse.mtj.api.model.preverifier.PreverificationErrorLocation;
import org.eclipse.mtj.api.model.preverifier.PreverificationErrorLocationType;
import org.eclipse.mtj.api.model.preverifier.PreverificationErrorType;
import org.eclipse.mtj.extension.preverify.internal.PreverifierMethodNode;
import org.eclipse.mtj.extension.preverify.internal.result.ClassNodeErrorInformation;
import org.eclipse.mtj.extension.preverify.internal.result.FieldErrorInformation;
import org.eclipse.mtj.extension.preverify.internal.result.MethodNodeErrorInformation;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class PreverificationClassNode
extends ClassNode {
    private static final Type BOOLEAN_TYPE = Type.getType((String)"Ljava/lang/Boolean;");
    private static final Type CHARACTER_TYPE = Type.getType((String)"Ljava/lang/Character;");
    private static final Type BYTE_TYPE = Type.getType((String)"Ljava/lang/Byte;");
    private static final Type SHORT_TYPE = Type.getType((String)"Ljava/lang/Short;");
    private static final Type INTEGER_TYPE = Type.getType((String)"Ljava/lang/Integer;");
    private static final Type FLOAT_TYPE = Type.getType((String)"Ljava/lang/Float;");
    private static final Type LONG_TYPE = Type.getType((String)"Ljava/lang/Long;");
    private static final Type DOUBLE_TYPE = Type.getType((String)"Ljava/lang/Double;");
    private static final Type VOID_TYPE = Type.getType((String)"Ljava/lang/Void;");
    private IPreverificationPolicy preverificationPolicy;
    private ArrayList errorList;
    private ClassLoader classLoader;
    private Map validTypes;
    private Class objectClass;
    private Class floatClass;
    private Class doubleClass;

    public PreverificationClassNode(IPreverificationPolicy preverificationPolicy, ClassLoader classloader) {
        this.preverificationPolicy = preverificationPolicy;
        this.errorList = new ArrayList();
        this.classLoader = classloader;
        this.validTypes = new HashMap();
        try {
            this.objectClass = Class.forName("java.lang.Object", true, this.classLoader);
            this.floatClass = Class.forName("java.lang.Float", true, this.classLoader);
            this.doubleClass = Class.forName("java.lang.Double", true, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public List getErrorList() {
        return this.errorList;
    }

    public boolean hasError() {
        return this.errorList.size() > 0;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fieldVisitor = null;
        Type type = Type.getType((String)desc);
        PreverificationErrorType error = this.validateType(type);
        if (error == PreverificationErrorType.NO_ERROR) {
            Object constantValue = (access & 8) != 0 ? value : null;
            fieldVisitor = super.visitField(access, name, desc, signature, constantValue);
        } else {
            ClassNodeErrorInformation classInfo = new ClassNodeErrorInformation(this);
            FieldErrorInformation fieldInfo = new FieldErrorInformation(name, desc);
            PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.CLASS_FIELD, (IClassErrorInformation)classInfo, null, (IFieldErrorInformation)fieldInfo, -1);
            PreverificationError fieldError = new PreverificationError(error, location, null);
            this.getErrorList().add(fieldError);
        }
        return fieldVisitor;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean isInvalidMethodSignature;
        PreverifierMethodNode mn = new PreverifierMethodNode(this, access, name, desc, signature, exceptions);
        boolean isNativeError = !this.preverificationPolicy.areNativeMethodsAllowed() && (access & 0x100) != 0;
        boolean isFinalizerError = !this.preverificationPolicy.areFinalizersAllowed() && name.equals("finalize") && Type.getArgumentTypes((String)desc).length == 0;
        PreverificationErrorType signatureErrorType = this.getMethodSignatureError(desc);
        boolean bl = isInvalidMethodSignature = signatureErrorType != PreverificationErrorType.NO_ERROR;
        if (isNativeError || isFinalizerError || isInvalidMethodSignature) {
            PreverificationError error;
            ClassNodeErrorInformation classInfo = new ClassNodeErrorInformation(this);
            MethodNodeErrorInformation methodInfo = new MethodNodeErrorInformation(classInfo, mn);
            PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_SIGNATURE, (IClassErrorInformation)classInfo, (IMethodErrorInformation)methodInfo, null, -1);
            if (isNativeError) {
                error = new PreverificationError(PreverificationErrorType.NATIVE, location, null);
                this.getErrorList().add(error);
            }
            if (isFinalizerError) {
                error = new PreverificationError(PreverificationErrorType.FINALIZERS, location, null);
                this.getErrorList().add(error);
            }
            if (isInvalidMethodSignature) {
                error = new PreverificationError(signatureErrorType, location, null);
                this.getErrorList().add(error);
            }
        }
        return mn;
    }

    private Type getObjectType(Type type) {
        Type objectType = type;
        switch (type.getSort()) {
            case 1: {
                objectType = BOOLEAN_TYPE;
                break;
            }
            case 2: {
                objectType = CHARACTER_TYPE;
                break;
            }
            case 3: {
                objectType = BYTE_TYPE;
                break;
            }
            case 4: {
                objectType = SHORT_TYPE;
                break;
            }
            case 5: {
                objectType = INTEGER_TYPE;
                break;
            }
            case 6: {
                objectType = FLOAT_TYPE;
                break;
            }
            case 7: {
                objectType = LONG_TYPE;
                break;
            }
            case 8: {
                objectType = DOUBLE_TYPE;
                break;
            }
            case 0: {
                objectType = VOID_TYPE;
                break;
            }
            case 9: {
                objectType = this.getObjectType(type.getElementType());
            }
        }
        return objectType;
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    IPreverificationPolicy getPreverificationPolicy() {
        return this.preverificationPolicy;
    }

    private Class getTypeClass(Type objectType) throws ClassNotFoundException {
        String dottedName = objectType.getInternalName().replace('/', '.');
        return Class.forName(dottedName, true, this.classLoader);
    }

    private boolean isDisallowedType(Class clazz) {
        boolean disallowed = false;
        if (!this.getPreverificationPolicy().isFloatingPointAllowed()) {
            disallowed = this.isFloatingPointType(clazz);
        }
        return disallowed;
    }

    private boolean isFloatingPointType(Class clazz) {
        return clazz == this.floatClass || clazz == this.doubleClass;
    }

    private PreverificationErrorType getMethodSignatureError(String desc) {
        Type returnType = Type.getReturnType((String)desc);
        PreverificationErrorType errorType = this.validateType(returnType);
        if (errorType != PreverificationErrorType.NO_ERROR) {
            Type[] paramTypes = Type.getArgumentTypes((String)desc);
            int i = 0;
            while (i < paramTypes.length && errorType != PreverificationErrorType.NO_ERROR) {
                errorType = this.validateType(paramTypes[i]);
                ++i;
            }
        }
        return errorType;
    }

    PreverificationErrorType validateType(Type type) {
        PreverificationErrorType errorCode = (PreverificationErrorType)this.validTypes.get(type);
        if (errorCode == null) {
            Type objectType = this.getObjectType(type);
            try {
                Class clazz = this.getTypeClass(objectType);
                errorCode = this.validateHierarchy(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                errorCode = PreverificationErrorType.MISSING_TYPE;
            }
            this.validTypes.put(type, errorCode);
        }
        return errorCode;
    }

    private PreverificationErrorType validateHierarchy(Class clazz) {
        PreverificationErrorType error = null;
        error = clazz == null || clazz == this.objectClass ? PreverificationErrorType.NO_ERROR : (this.isDisallowedType(clazz) ? PreverificationErrorType.FLOATING_POINT : this.validateHierarchy(clazz.getSuperclass()));
        return error;
    }
}

