/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.psp.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.PersistentStoreProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.MtjNotFoundException;
import org.eclipse.mtj.extension.psp.Messages;
import org.eclipse.mtj.extension.psp.PersistentStoreProviderPlugin;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;

public class PersistentStoreProviderImpl
extends MtjExtensionImpl
implements PersistentStoreProvider {
    private boolean storeToHome = false;

    public PersistentStoreProviderImpl() {
        this.setId(PersistentStoreProviderPlugin.getDefault().getBundle().getSymbolicName());
        this.setDescription(Messages.PersistentStoreProviderImpl_PluginDescription);
        this.setVendor(Messages.PersistentStoreProviderImpl_PluginVendor);
        this.setVersion(Messages.PersistentStoreProviderImpl_PluginVersion);
        this.setType(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL);
    }

    public void store(Object data, int dataType, String dataExtension, String ownerPluginName, String dataKey) throws MtjException {
        try {
            String filename = this.getFileName(dataExtension, ownerPluginName, dataKey);
            this.store(data, dataType, dataExtension, filename);
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
    }

    public void store(Object data, int dataType, String dataExtension, String filename) throws MtjException {
        try {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(dataExtension, new XMIResourceFactoryImpl());
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource res = resSet.createResource(URI.createURI((String)filename));
            if (data instanceof EList) {
                Iterator it = ((EList)data).iterator();
                while (it.hasNext()) {
                    res.getContents().add(it.next());
                }
            } else {
                res.getContents().add(data);
            }
            res.save(Collections.EMPTY_MAP);
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
    }

    public Object get(int dataType, String dataExtension, String ownerPluginName, String dataKey) throws MtjException {
        try {
            String filename = this.getFileName(dataExtension, ownerPluginName, dataKey);
            return this.get(dataType, dataExtension, filename);
        }
        catch (MtjException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
    }

    public Object get(int dataType, String dataExtension, String filename) throws MtjException {
        try {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(dataExtension, new XMIResourceFactoryImpl());
            ResourceSetImpl resSet = new ResourceSetImpl();
            Resource res = resSet.getResource(URI.createURI((String)filename), true);
            return res.getContents();
        }
        catch (WrappedException ex) {
            if (ex.exception() != null && ex.exception() instanceof FileNotFoundException) {
                throw new MtjNotFoundException(ex.getLocalizedMessage());
            }
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
    }

    private String getFileName(String dataExtension, String ownerPluginName, String dataKey) throws IOException {
        String url = "";
        StringBuffer sb = new StringBuffer();
        Path path = new Path("");
        if (this.storeToHome) {
            Location location = Platform.getUserLocation();
            url = location.getURL() + ".mtj/data/";
            File file = new File(url);
            if (!file.exists()) {
                file.mkdirs();
            }
            sb.append(url);
        } else {
            url = FileLocator.toFileURL((URL)FileLocator.find((Bundle)PersistentStoreProviderPlugin.getDefault().getBundle(), (IPath)path, null)).toString();
            sb.append(url);
            sb.append("data/");
        }
        sb.append(ownerPluginName);
        sb.append("/");
        sb.append(dataKey);
        sb.append(".");
        sb.append(dataExtension);
        return sb.toString();
    }
}

