/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.devices.Configuration#getItems <em>Items</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Configuration#getErrors <em>Errors</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.devices.DevicesPackage#getConfiguration()
 * @model
 * @generated
 */
public interface Configuration extends EObject {
	/**
	 * Returns the value of the '<em><b>Items</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.devices.ConfigurationItem}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Items</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Items</em>' containment reference list.
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getConfiguration_Items()
	 * @model type="org.eclipse.mtj.api.devices.ConfigurationItem" containment="true"
	 * @generated
	 */
	EList getItems();

	/**
	 * Returns the value of the '<em><b>Errors</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.devices.ConfigurationError}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Errors</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Errors</em>' containment reference list.
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getConfiguration_Errors()
	 * @model type="org.eclipse.mtj.api.devices.ConfigurationError" containment="true"
	 * @generated
	 */
	EList getErrors();

} // Configuration
