/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Configuration Error</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.devices.ConfigurationError#getItem <em>Item</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.ConfigurationError#getErrorType <em>Error Type</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.ConfigurationError#getDescription <em>Description</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.devices.DevicesPackage#getConfigurationError()
 * @model
 * @generated
 */
public interface ConfigurationError extends EObject {
	/**
	 * Returns the value of the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Item</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Item</em>' reference.
	 * @see #setItem(ConfigurationItem)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getConfigurationError_Item()
	 * @model required="true"
	 * @generated
	 */
	ConfigurationItem getItem();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.ConfigurationError#getItem <em>Item</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Item</em>' reference.
	 * @see #getItem()
	 * @generated
	 */
	void setItem(ConfigurationItem value);

	/**
	 * Returns the value of the '<em><b>Error Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Error Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Error Type</em>' attribute.
	 * @see #setErrorType(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getConfigurationError_ErrorType()
	 * @model
	 * @generated
	 */
	String getErrorType();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.ConfigurationError#getErrorType <em>Error Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Error Type</em>' attribute.
	 * @see #getErrorType()
	 * @generated
	 */
	void setErrorType(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getConfigurationError_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.ConfigurationError#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

} // ConfigurationError
