/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.devices.DevicesPackage
 * @generated
 */
public interface DevicesFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	DevicesFactory eINSTANCE = new org.eclipse.mtj.api.devices.impl.DevicesFactoryImpl();

	/**
	 * Returns a new object of class '<em>Device Platform</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Device Platform</em>'.
	 * @generated
	 */
	DevicePlatform createDevicePlatform();

	/**
	 * Returns a new object of class '<em>Device</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Device</em>'.
	 * @generated
	 */
	Device createDevice();

	/**
	 * Returns a new object of class '<em>Configuration</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Configuration</em>'.
	 * @generated
	 */
	Configuration createConfiguration();

	/**
	 * Returns a new object of class '<em>Configuration Item</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Configuration Item</em>'.
	 * @generated
	 */
	ConfigurationItem createConfigurationItem();

	/**
	 * Returns a new object of class '<em>Configuration Error</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Configuration Error</em>'.
	 * @generated
	 */
	ConfigurationError createConfigurationError();

	/**
	 * Returns a new object of class '<em>Protection Domain</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Protection Domain</em>'.
	 * @generated
	 */
	ProtectionDomain createProtectionDomain();

	/**
	 * Returns a new object of class '<em>Permission</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Permission</em>'.
	 * @generated
	 */
	Permission createPermission();

	/**
	 * Returns a new object of class '<em>Device Description</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Device Description</em>'.
	 * @generated
	 */
	DeviceDescription createDeviceDescription();

	/**
	 * Returns a new object of class '<em>Device Capability</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Device Capability</em>'.
	 * @generated
	 */
	DeviceCapability createDeviceCapability();

	/**
	 * Returns a new object of class '<em>Device Feature</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Device Feature</em>'.
	 * @generated
	 */
	DeviceFeature createDeviceFeature();

	/**
	 * Returns a new object of class '<em>Device Group</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Device Group</em>'.
	 * @generated
	 */
	DeviceGroup createDeviceGroup();

	/**
	 * Returns a new object of class '<em>Configuration Value</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Configuration Value</em>'.
	 * @generated
	 */
	ConfigurationValue createConfigurationValue();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	DevicesPackage getDevicesPackage();

} //DevicesFactory
