/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Platform Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getPlatformType()
 * @model
 * @generated
 */
public final class PlatformType extends AbstractEnumerator {
	/**
	 * The '<em><b>EXECUTABLE EMULATOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXECUTABLE EMULATOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXECUTABLE_EMULATOR_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXECUTABLE_EMULATOR = 0;

	/**
	 * The '<em><b>JAVA BASED EMULATOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>JAVA BASED EMULATOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #JAVA_BASED_EMULATOR_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int JAVA_BASED_EMULATOR = 1;

	/**
	 * The '<em><b>OTA EMULATOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OTA EMULATOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OTA_EMULATOR_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OTA_EMULATOR = 2;

	/**
	 * The '<em><b>REAL DEVICE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>REAL DEVICE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #REAL_DEVICE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int REAL_DEVICE = 3;

	/**
	 * The '<em><b>EXECUTABLE EMULATOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXECUTABLE_EMULATOR
	 * @generated
	 * @ordered
	 */
	public static final PlatformType EXECUTABLE_EMULATOR_LITERAL = new PlatformType(EXECUTABLE_EMULATOR, "EXECUTABLE_EMULATOR");

	/**
	 * The '<em><b>JAVA BASED EMULATOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #JAVA_BASED_EMULATOR
	 * @generated
	 * @ordered
	 */
	public static final PlatformType JAVA_BASED_EMULATOR_LITERAL = new PlatformType(JAVA_BASED_EMULATOR, "JAVA_BASED_EMULATOR");

	/**
	 * The '<em><b>OTA EMULATOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OTA_EMULATOR
	 * @generated
	 * @ordered
	 */
	public static final PlatformType OTA_EMULATOR_LITERAL = new PlatformType(OTA_EMULATOR, "OTA_EMULATOR");

	/**
	 * The '<em><b>REAL DEVICE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REAL_DEVICE
	 * @generated
	 * @ordered
	 */
	public static final PlatformType REAL_DEVICE_LITERAL = new PlatformType(REAL_DEVICE, "REAL_DEVICE");

	/**
	 * An array of all the '<em><b>Platform Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final PlatformType[] VALUES_ARRAY =
		new PlatformType[] {
			EXECUTABLE_EMULATOR_LITERAL,
			JAVA_BASED_EMULATOR_LITERAL,
			OTA_EMULATOR_LITERAL,
			REAL_DEVICE_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Platform Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Platform Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static PlatformType get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			PlatformType result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Platform Type</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static PlatformType get(int value) {
		switch (value) {
			case EXECUTABLE_EMULATOR: return EXECUTABLE_EMULATOR_LITERAL;
			case JAVA_BASED_EMULATOR: return JAVA_BASED_EMULATOR_LITERAL;
			case OTA_EMULATOR: return OTA_EMULATOR_LITERAL;
			case REAL_DEVICE: return REAL_DEVICE_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private PlatformType(int value, String name) {
		super(value, name);
	}

} //PlatformType
