/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.eclipse.mtj.api.deployment.DeploymentPackage;

import org.eclipse.mtj.api.deployment.impl.DeploymentPackageImpl;

import org.eclipse.mtj.api.devices.DevicesPackage;

import org.eclipse.mtj.api.devices.impl.DevicesPackageImpl;

import org.eclipse.mtj.api.enumerations.EnumerationsPackage;

import org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl;

import org.eclipse.mtj.api.extension.ExtensionPackage;

import org.eclipse.mtj.api.extension.impl.ExtensionPackageImpl;

import org.eclipse.mtj.api.preprocessing.PreprocessingPackage;

import org.eclipse.mtj.api.preprocessing.impl.PreprocessingPackageImpl;

import org.eclipse.mtj.api.project.DebugConfiguration;
import org.eclipse.mtj.api.project.ObfuscationDetail;
import org.eclipse.mtj.api.project.PackagingDetails;
import org.eclipse.mtj.api.project.Parameter;
import org.eclipse.mtj.api.project.PreprocessingDetail;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.ProjectPackage;
import org.eclipse.mtj.api.project.SigningDetail;
import org.eclipse.mtj.api.project.TargetDevice;

import org.eclipse.mtj.api.runtimes.RuntimesPackage;

import org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl;

import org.eclipse.mtj.api.signings.SigningsPackage;

import org.eclipse.mtj.api.signings.impl.SigningsPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ProjectPackageImpl extends EPackageImpl implements ProjectPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass projectEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass obfuscationDetailEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass debugConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass targetDeviceEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass preprocessingDetailEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass signingDetailEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass packagingDetailsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass parameterEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.mtj.api.project.ProjectPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ProjectPackageImpl() {
		super(eNS_URI, ProjectFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ProjectPackage init() {
		if (isInited) return (ProjectPackage)EPackage.Registry.INSTANCE.getEPackage(ProjectPackage.eNS_URI);

		// Obtain or create and register package
		ProjectPackageImpl theProjectPackage = (ProjectPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof ProjectPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new ProjectPackageImpl());

		isInited = true;

		// Obtain or create and register interdependencies
		DevicesPackageImpl theDevicesPackage = (DevicesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(DevicesPackage.eNS_URI) instanceof DevicesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(DevicesPackage.eNS_URI) : DevicesPackage.eINSTANCE);
		ExtensionPackageImpl theExtensionPackage = (ExtensionPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(ExtensionPackage.eNS_URI) instanceof ExtensionPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(ExtensionPackage.eNS_URI) : ExtensionPackage.eINSTANCE);
		RuntimesPackageImpl theRuntimesPackage = (RuntimesPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(RuntimesPackage.eNS_URI) instanceof RuntimesPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(RuntimesPackage.eNS_URI) : RuntimesPackage.eINSTANCE);
		EnumerationsPackageImpl theEnumerationsPackage = (EnumerationsPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(EnumerationsPackage.eNS_URI) instanceof EnumerationsPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(EnumerationsPackage.eNS_URI) : EnumerationsPackage.eINSTANCE);
		PreprocessingPackageImpl thePreprocessingPackage = (PreprocessingPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(PreprocessingPackage.eNS_URI) instanceof PreprocessingPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(PreprocessingPackage.eNS_URI) : PreprocessingPackage.eINSTANCE);
		DeploymentPackageImpl theDeploymentPackage = (DeploymentPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(DeploymentPackage.eNS_URI) instanceof DeploymentPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(DeploymentPackage.eNS_URI) : DeploymentPackage.eINSTANCE);
		SigningsPackageImpl theSigningsPackage = (SigningsPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(SigningsPackage.eNS_URI) instanceof SigningsPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(SigningsPackage.eNS_URI) : SigningsPackage.eINSTANCE);

		// Create package meta-data objects
		theProjectPackage.createPackageContents();
		theDevicesPackage.createPackageContents();
		theExtensionPackage.createPackageContents();
		theRuntimesPackage.createPackageContents();
		theEnumerationsPackage.createPackageContents();
		thePreprocessingPackage.createPackageContents();
		theDeploymentPackage.createPackageContents();
		theSigningsPackage.createPackageContents();

		// Initialize created meta-data
		theProjectPackage.initializePackageContents();
		theDevicesPackage.initializePackageContents();
		theExtensionPackage.initializePackageContents();
		theRuntimesPackage.initializePackageContents();
		theEnumerationsPackage.initializePackageContents();
		thePreprocessingPackage.initializePackageContents();
		theDeploymentPackage.initializePackageContents();
		theSigningsPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theProjectPackage.freeze();

		return theProjectPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getProject() {
		return projectEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProject_Type() {
		return (EAttribute)projectEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProject_TargetDevices() {
		return (EReference)projectEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProject_DefaultTargetDevice() {
		return (EReference)projectEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProject_ObfuscationDetail() {
		return (EReference)projectEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getProject_Name() {
		return (EAttribute)projectEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProject_PackagingDetails() {
		return (EReference)projectEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getProject_DefaultDeploymentDevice() {
		return (EReference)projectEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getObfuscationDetail() {
		return obfuscationDetailEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getObfuscationDetail_Level() {
		return (EAttribute)obfuscationDetailEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getObfuscationDetail_AdditionalSettings() {
		return (EAttribute)obfuscationDetailEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getDebugConfiguration() {
		return debugConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTargetDevice() {
		return targetDeviceEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTargetDevice_SigningDetails() {
		return (EReference)targetDeviceEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTargetDevice_PreprocessingDetails() {
		return (EReference)targetDeviceEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTargetDevice_RuntimePlatform() {
		return (EReference)targetDeviceEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTargetDevice_Name() {
		return (EAttribute)targetDeviceEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTargetDevice_Description() {
		return (EAttribute)targetDeviceEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTargetDevice_DevicePlatformName() {
		return (EAttribute)targetDeviceEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTargetDevice_DeviceName() {
		return (EAttribute)targetDeviceEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTargetDevice_DeviceGroupName() {
		return (EAttribute)targetDeviceEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPreprocessingDetail() {
		return preprocessingDetailEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPreprocessingDetail_Condition() {
		return (EAttribute)preprocessingDetailEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getSigningDetail() {
		return signingDetailEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSigningDetail_Keystore() {
		return (EAttribute)signingDetailEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getSigningDetail_Alias() {
		return (EAttribute)signingDetailEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getPackagingDetails() {
		return packagingDetailsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getPackagingDetails_IncrementVersionAutomatically() {
		return (EAttribute)packagingDetailsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getPackagingDetails_ExculedManifestEntries() {
		return (EReference)packagingDetailsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getParameter() {
		return parameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getParameter_Name() {
		return (EAttribute)parameterEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProjectFactory getProjectFactory() {
		return (ProjectFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		projectEClass = createEClass(PROJECT);
		createEAttribute(projectEClass, PROJECT__TYPE);
		createEReference(projectEClass, PROJECT__TARGET_DEVICES);
		createEReference(projectEClass, PROJECT__DEFAULT_TARGET_DEVICE);
		createEReference(projectEClass, PROJECT__OBFUSCATION_DETAIL);
		createEAttribute(projectEClass, PROJECT__NAME);
		createEReference(projectEClass, PROJECT__PACKAGING_DETAILS);
		createEReference(projectEClass, PROJECT__DEFAULT_DEPLOYMENT_DEVICE);

		obfuscationDetailEClass = createEClass(OBFUSCATION_DETAIL);
		createEAttribute(obfuscationDetailEClass, OBFUSCATION_DETAIL__LEVEL);
		createEAttribute(obfuscationDetailEClass, OBFUSCATION_DETAIL__ADDITIONAL_SETTINGS);

		debugConfigurationEClass = createEClass(DEBUG_CONFIGURATION);

		targetDeviceEClass = createEClass(TARGET_DEVICE);
		createEReference(targetDeviceEClass, TARGET_DEVICE__SIGNING_DETAILS);
		createEReference(targetDeviceEClass, TARGET_DEVICE__PREPROCESSING_DETAILS);
		createEReference(targetDeviceEClass, TARGET_DEVICE__RUNTIME_PLATFORM);
		createEAttribute(targetDeviceEClass, TARGET_DEVICE__NAME);
		createEAttribute(targetDeviceEClass, TARGET_DEVICE__DESCRIPTION);
		createEAttribute(targetDeviceEClass, TARGET_DEVICE__DEVICE_PLATFORM_NAME);
		createEAttribute(targetDeviceEClass, TARGET_DEVICE__DEVICE_NAME);
		createEAttribute(targetDeviceEClass, TARGET_DEVICE__DEVICE_GROUP_NAME);

		preprocessingDetailEClass = createEClass(PREPROCESSING_DETAIL);
		createEAttribute(preprocessingDetailEClass, PREPROCESSING_DETAIL__CONDITION);

		signingDetailEClass = createEClass(SIGNING_DETAIL);
		createEAttribute(signingDetailEClass, SIGNING_DETAIL__KEYSTORE);
		createEAttribute(signingDetailEClass, SIGNING_DETAIL__ALIAS);

		packagingDetailsEClass = createEClass(PACKAGING_DETAILS);
		createEAttribute(packagingDetailsEClass, PACKAGING_DETAILS__INCREMENT_VERSION_AUTOMATICALLY);
		createEReference(packagingDetailsEClass, PACKAGING_DETAILS__EXCULED_MANIFEST_ENTRIES);

		parameterEClass = createEClass(PARAMETER);
		createEAttribute(parameterEClass, PARAMETER__NAME);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EnumerationsPackageImpl theEnumerationsPackage = (EnumerationsPackageImpl)EPackage.Registry.INSTANCE.getEPackage(EnumerationsPackage.eNS_URI);
		RuntimesPackageImpl theRuntimesPackage = (RuntimesPackageImpl)EPackage.Registry.INSTANCE.getEPackage(RuntimesPackage.eNS_URI);

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(projectEClass, Project.class, "Project", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getProject_Type(), theEnumerationsPackage.getProjectType(), "type", null, 1, 1, Project.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProject_TargetDevices(), this.getTargetDevice(), null, "targetDevices", null, 1, -1, Project.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProject_DefaultTargetDevice(), this.getTargetDevice(), null, "defaultTargetDevice", null, 0, 1, Project.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProject_ObfuscationDetail(), this.getObfuscationDetail(), null, "obfuscationDetail", null, 0, 1, Project.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getProject_Name(), ecorePackage.getEString(), "name", null, 0, 1, Project.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProject_PackagingDetails(), this.getPackagingDetails(), null, "PackagingDetails", null, 0, 1, Project.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getProject_DefaultDeploymentDevice(), this.getTargetDevice(), null, "defaultDeploymentDevice", null, 0, 1, Project.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(obfuscationDetailEClass, ObfuscationDetail.class, "ObfuscationDetail", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getObfuscationDetail_Level(), ecorePackage.getEInt(), "level", null, 0, 1, ObfuscationDetail.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getObfuscationDetail_AdditionalSettings(), ecorePackage.getEString(), "additionalSettings", null, 0, 1, ObfuscationDetail.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(debugConfigurationEClass, DebugConfiguration.class, "DebugConfiguration", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(targetDeviceEClass, TargetDevice.class, "TargetDevice", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getTargetDevice_SigningDetails(), this.getSigningDetail(), null, "signingDetails", null, 0, -1, TargetDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTargetDevice_PreprocessingDetails(), this.getPreprocessingDetail(), null, "preprocessingDetails", null, 0, -1, TargetDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getTargetDevice_RuntimePlatform(), theRuntimesPackage.getRuntimePlatformDefinition(), null, "runtimePlatform", null, 1, 1, TargetDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTargetDevice_Name(), ecorePackage.getEString(), "name", null, 0, 1, TargetDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTargetDevice_Description(), ecorePackage.getEString(), "description", null, 0, 1, TargetDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTargetDevice_DevicePlatformName(), ecorePackage.getEString(), "devicePlatformName", null, 0, 1, TargetDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTargetDevice_DeviceName(), ecorePackage.getEString(), "deviceName", null, 0, 1, TargetDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTargetDevice_DeviceGroupName(), ecorePackage.getEString(), "deviceGroupName", null, 0, 1, TargetDevice.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(preprocessingDetailEClass, PreprocessingDetail.class, "PreprocessingDetail", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPreprocessingDetail_Condition(), ecorePackage.getEString(), "condition", null, 0, 1, PreprocessingDetail.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(signingDetailEClass, SigningDetail.class, "SigningDetail", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSigningDetail_Keystore(), ecorePackage.getEString(), "keystore", null, 0, 1, SigningDetail.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSigningDetail_Alias(), ecorePackage.getEString(), "alias", null, 0, 1, SigningDetail.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(packagingDetailsEClass, PackagingDetails.class, "PackagingDetails", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPackagingDetails_IncrementVersionAutomatically(), ecorePackage.getEBoolean(), "incrementVersionAutomatically", null, 0, 1, PackagingDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getPackagingDetails_ExculedManifestEntries(), this.getParameter(), null, "exculedManifestEntries", null, 0, -1, PackagingDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(parameterEClass, Parameter.class, "Parameter", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getParameter_Name(), ecorePackage.getEString(), "name", null, 0, 1, Parameter.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);
	}

} //ProjectPackageImpl
