/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.JvmImplementation;
import org.eclipse.mtj.api.runtimes.RuntimesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Device Configuration</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.DeviceConfigurationImpl#getImplementation <em>Implementation</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.DeviceConfigurationImpl#getJvmRef <em>Jvm Ref</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.DeviceConfigurationImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.DeviceConfigurationImpl#getVersion <em>Version</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DeviceConfigurationImpl extends EObjectImpl implements DeviceConfiguration {
	/**
	 * The cached value of the '{@link #getImplementation() <em>Implementation</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImplementation()
	 * @generated
	 * @ordered
	 */
	protected ImplementationRef implementation = null;

	/**
	 * The cached value of the '{@link #getJvmRef() <em>Jvm Ref</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJvmRef()
	 * @generated
	 * @ordered
	 */
	protected JvmImplementation jvmRef = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeviceConfigurationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RuntimesPackage.eINSTANCE.getDeviceConfiguration();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ImplementationRef getImplementation() {
		return implementation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetImplementation(ImplementationRef newImplementation, NotificationChain msgs) {
		ImplementationRef oldImplementation = implementation;
		implementation = newImplementation;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION, oldImplementation, newImplementation);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setImplementation(ImplementationRef newImplementation) {
		if (newImplementation != implementation) {
			NotificationChain msgs = null;
			if (implementation != null)
				msgs = ((InternalEObject)implementation).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION, null, msgs);
			if (newImplementation != null)
				msgs = ((InternalEObject)newImplementation).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION, null, msgs);
			msgs = basicSetImplementation(newImplementation, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION, newImplementation, newImplementation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JvmImplementation getJvmRef() {
		return jvmRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetJvmRef(JvmImplementation newJvmRef, NotificationChain msgs) {
		JvmImplementation oldJvmRef = jvmRef;
		jvmRef = newJvmRef;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF, oldJvmRef, newJvmRef);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setJvmRef(JvmImplementation newJvmRef) {
		if (newJvmRef != jvmRef) {
			NotificationChain msgs = null;
			if (jvmRef != null)
				msgs = ((InternalEObject)jvmRef).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF, null, msgs);
			if (newJvmRef != null)
				msgs = ((InternalEObject)newJvmRef).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF, null, msgs);
			msgs = basicSetJvmRef(newJvmRef, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF, newJvmRef, newJvmRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.DEVICE_CONFIGURATION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(String newVersion) {
		String oldVersion = version;
		version = newVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.DEVICE_CONFIGURATION__VERSION, oldVersion, version));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION:
					return basicSetImplementation(null, msgs);
				case RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF:
					return basicSetJvmRef(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION:
				return getImplementation();
			case RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF:
				return getJvmRef();
			case RuntimesPackage.DEVICE_CONFIGURATION__NAME:
				return getName();
			case RuntimesPackage.DEVICE_CONFIGURATION__VERSION:
				return getVersion();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION:
				setImplementation((ImplementationRef)newValue);
				return;
			case RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF:
				setJvmRef((JvmImplementation)newValue);
				return;
			case RuntimesPackage.DEVICE_CONFIGURATION__NAME:
				setName((String)newValue);
				return;
			case RuntimesPackage.DEVICE_CONFIGURATION__VERSION:
				setVersion((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION:
				setImplementation((ImplementationRef)null);
				return;
			case RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF:
				setJvmRef((JvmImplementation)null);
				return;
			case RuntimesPackage.DEVICE_CONFIGURATION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case RuntimesPackage.DEVICE_CONFIGURATION__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.DEVICE_CONFIGURATION__IMPLEMENTATION:
				return implementation != null;
			case RuntimesPackage.DEVICE_CONFIGURATION__JVM_REF:
				return jvmRef != null;
			case RuntimesPackage.DEVICE_CONFIGURATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case RuntimesPackage.DEVICE_CONFIGURATION__VERSION:
				return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", version: ");
		result.append(version);
		result.append(')');
		return result.toString();
	}

} //DeviceConfigurationImpl
