/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Implementation Ref</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.ImplementationRefImpl#getFileRef <em>File Ref</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.ImplementationRefImpl#getSourceRef <em>Source Ref</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.ImplementationRefImpl#getJavadocRef <em>Javadoc Ref</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ImplementationRefImpl extends EObjectImpl implements ImplementationRef {
	/**
	 * The default value of the '{@link #getFileRef() <em>File Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFileRef()
	 * @generated
	 * @ordered
	 */
	protected static final String FILE_REF_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFileRef() <em>File Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFileRef()
	 * @generated
	 * @ordered
	 */
	protected String fileRef = FILE_REF_EDEFAULT;

	/**
	 * The default value of the '{@link #getSourceRef() <em>Source Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceRef()
	 * @generated
	 * @ordered
	 */
	protected static final String SOURCE_REF_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSourceRef() <em>Source Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceRef()
	 * @generated
	 * @ordered
	 */
	protected String sourceRef = SOURCE_REF_EDEFAULT;

	/**
	 * The default value of the '{@link #getJavadocRef() <em>Javadoc Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJavadocRef()
	 * @generated
	 * @ordered
	 */
	protected static final String JAVADOC_REF_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getJavadocRef() <em>Javadoc Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getJavadocRef()
	 * @generated
	 * @ordered
	 */
	protected String javadocRef = JAVADOC_REF_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ImplementationRefImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RuntimesPackage.eINSTANCE.getImplementationRef();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFileRef() {
		return fileRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFileRef(String newFileRef) {
		String oldFileRef = fileRef;
		fileRef = newFileRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.IMPLEMENTATION_REF__FILE_REF, oldFileRef, fileRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSourceRef() {
		return sourceRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceRef(String newSourceRef) {
		String oldSourceRef = sourceRef;
		sourceRef = newSourceRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.IMPLEMENTATION_REF__SOURCE_REF, oldSourceRef, sourceRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getJavadocRef() {
		return javadocRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setJavadocRef(String newJavadocRef) {
		String oldJavadocRef = javadocRef;
		javadocRef = newJavadocRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.IMPLEMENTATION_REF__JAVADOC_REF, oldJavadocRef, javadocRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.IMPLEMENTATION_REF__FILE_REF:
				return getFileRef();
			case RuntimesPackage.IMPLEMENTATION_REF__SOURCE_REF:
				return getSourceRef();
			case RuntimesPackage.IMPLEMENTATION_REF__JAVADOC_REF:
				return getJavadocRef();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.IMPLEMENTATION_REF__FILE_REF:
				setFileRef((String)newValue);
				return;
			case RuntimesPackage.IMPLEMENTATION_REF__SOURCE_REF:
				setSourceRef((String)newValue);
				return;
			case RuntimesPackage.IMPLEMENTATION_REF__JAVADOC_REF:
				setJavadocRef((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.IMPLEMENTATION_REF__FILE_REF:
				setFileRef(FILE_REF_EDEFAULT);
				return;
			case RuntimesPackage.IMPLEMENTATION_REF__SOURCE_REF:
				setSourceRef(SOURCE_REF_EDEFAULT);
				return;
			case RuntimesPackage.IMPLEMENTATION_REF__JAVADOC_REF:
				setJavadocRef(JAVADOC_REF_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.IMPLEMENTATION_REF__FILE_REF:
				return FILE_REF_EDEFAULT == null ? fileRef != null : !FILE_REF_EDEFAULT.equals(fileRef);
			case RuntimesPackage.IMPLEMENTATION_REF__SOURCE_REF:
				return SOURCE_REF_EDEFAULT == null ? sourceRef != null : !SOURCE_REF_EDEFAULT.equals(sourceRef);
			case RuntimesPackage.IMPLEMENTATION_REF__JAVADOC_REF:
				return JAVADOC_REF_EDEFAULT == null ? javadocRef != null : !JAVADOC_REF_EDEFAULT.equals(javadocRef);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (fileRef: ");
		result.append(fileRef);
		result.append(", sourceRef: ");
		result.append(sourceRef);
		result.append(", javadocRef: ");
		result.append(javadocRef);
		result.append(')');
		return result.toString();
	}

} //ImplementationRefImpl
