/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.signings;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.signings.SigningsFactory
 * @model kind="package"
 * @generated
 */
public interface SigningsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "signings";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///org/eclipse/mtj/api/signings.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.eclipse.mtj.api.signings";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SigningsPackage eINSTANCE = org.eclipse.mtj.api.signings.impl.SigningsPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.signings.impl.SigningCertificateImpl <em>Signing Certificate</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.signings.impl.SigningCertificateImpl
	 * @see org.eclipse.mtj.api.signings.impl.SigningsPackageImpl#getSigningCertificate()
	 * @generated
	 */
	int SIGNING_CERTIFICATE = 0;

	/**
	 * The feature id for the '<em><b>Keystore</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNING_CERTIFICATE__KEYSTORE = 0;

	/**
	 * The feature id for the '<em><b>Alias Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNING_CERTIFICATE__ALIAS_NAME = 1;

	/**
	 * The feature id for the '<em><b>Keystore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNING_CERTIFICATE__KEYSTORE_PASSWORD = 2;

	/**
	 * The feature id for the '<em><b>Certificate Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNING_CERTIFICATE__CERTIFICATE_PASSWORD = 3;

	/**
	 * The number of structural features of the the '<em>Signing Certificate</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNING_CERTIFICATE_FEATURE_COUNT = 4;


	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.signings.SigningCertificate <em>Signing Certificate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signing Certificate</em>'.
	 * @see org.eclipse.mtj.api.signings.SigningCertificate
	 * @generated
	 */
	EClass getSigningCertificate();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.signings.SigningCertificate#getKeystore <em>Keystore</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keystore</em>'.
	 * @see org.eclipse.mtj.api.signings.SigningCertificate#getKeystore()
	 * @see #getSigningCertificate()
	 * @generated
	 */
	EAttribute getSigningCertificate_Keystore();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.signings.SigningCertificate#getAliasName <em>Alias Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alias Name</em>'.
	 * @see org.eclipse.mtj.api.signings.SigningCertificate#getAliasName()
	 * @see #getSigningCertificate()
	 * @generated
	 */
	EAttribute getSigningCertificate_AliasName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.signings.SigningCertificate#getKeystorePassword <em>Keystore Password</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keystore Password</em>'.
	 * @see org.eclipse.mtj.api.signings.SigningCertificate#getKeystorePassword()
	 * @see #getSigningCertificate()
	 * @generated
	 */
	EAttribute getSigningCertificate_KeystorePassword();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.signings.SigningCertificate#getCertificatePassword <em>Certificate Password</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Certificate Password</em>'.
	 * @see org.eclipse.mtj.api.signings.SigningCertificate#getCertificatePassword()
	 * @see #getSigningCertificate()
	 * @generated
	 */
	EAttribute getSigningCertificate_CertificatePassword();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	SigningsFactory getSigningsFactory();

} //SigningsPackage
