/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.executable.uei;

import java.io.File;

import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ServiceApi;

public interface IServiceApiImporter {
	
	DeviceProfile[] getProfileApis(String bootclasspath);
	
	DeviceProfile[] getProfileApis(File libraryFile);
	
	DeviceConfiguration[] getConfigurationApis(String bootclasspath);
	
	DeviceConfiguration[] getConfigurationApis(File libraryFile);

		/**
		 * Creates ServiceApi objects from the provided classpath location
		 * @param bootclasspath parameter as specified in UEI
		 * @return
		 */
		ServiceApi[] getServiceApis(String bootclasspath);
		
		/**
		 * Creates ServiceApi objects from the provided library file
		 * @param libraryFile *.jar, *.zip or other
		 * @return
		 */
		ServiceApi[] getServiceApis(File libraryFile);
}
