/*******************************************************************************
* Copyright (c) 2006 IBM.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.bp.anttask;

import java.util.Properties;

import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpPackaging;

public class MidpPackagingAntTask extends BuildProviderBaseAntTask {

	Properties projectProps;
	private String deployDir = null;
	private String binaryDir = null;

	boolean debug=false;

	public MidpPackagingAntTask() {
		super();
	}

	public void doRun (IMtjProject mtjProject, IProgressMonitor monitor) throws CoreException, MtjException 
	{
		this.mtjProject = mtjProject;
		this.monitor = monitor;
		
		MidpPackaging packaging = new MidpPackaging (mtjProject, monitor);
		if (getDeployDir() != null)
		{	
			packaging.setDeploymentFolder(convertProjectRelativeLocationToIFolder(getDeployDir()));
		}
		if (getBinaryDir() != null)
		{
			packaging.setBinaryFolder(convertProjectRelativeLocationToIFolder(getBinaryDir() + "/bin")); //$NON-NLS-1$
			packaging.setBinaryLibFolder(convertProjectRelativeLocationToIFolder(getBinaryDir() + "/lib")); //$NON-NLS-1$
		}
		packaging.performPackaging(natureId);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.mtj.extension.bp.anttask.BuildProviderBaseAntTask#doExecute()
	 */
	public void run() {
	
		try {
			if (mtjProject != null)
			{
				doRun (mtjProject, monitor);
			}
		} catch (MtjException e) {
			throw new BuildException (e);
		} catch (CoreException e) {
			throw new BuildException (e);
		}
	}

	/**
	 * @return Returns the deployDir.
	 */
	public String getDeployDir() {
		return deployDir;
	}

	/**
	 * @param deployDir The deployDir to set.
	 */
	public void setDeployDir(String deployDir) {
		this.deployDir = deployDir;
	}
	
	/**
	 * @return Returns the deployDir.
	 */
	public String getBinaryDir() {
		return binaryDir;
	}

	/**
	 * @param deployDir The deployDir to set.
	 */
	public void setBinaryDir(String binaryDir) {
		this.binaryDir = binaryDir;
	}
	
}
