/*******************************************************************************
* Copyright (c) 2006 IBM.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.bp.anttask;


import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.midp.MidpPreverify;

public class MidpPreverifyAntTask extends BuildProviderBaseAntTask {

	
	boolean debug=false;
	private String binaryDir = null;
	private String classesDir = null;

	public MidpPreverifyAntTask() {
		super();
	}

	public void doRun (IMtjProject mtjProject, IProgressMonitor monitor) throws CoreException, MtjException 
	{
		this.mtjProject = mtjProject;
		this.monitor = monitor;

		RuntimePlatformDefinition targetPlatform;

		Project data = mtjProject.getProjectData();
		if (data == null
				|| data.getDefaultTargetDevice() == null
				|| data.getDefaultTargetDevice().getRuntimePlatform() == null) {
			return; // Log error message
		}
		targetPlatform = data.getDefaultTargetDevice().getRuntimePlatform();
		if (mtjProject != null)
		{
			MidpPreverify preVerify = new MidpPreverify (mtjProject, monitor);
			if (getClassesDir() != null)
			{
				preVerify.setClassesDir(convertProjectRelativeLocationToIFolder(getClassesDir()));
			}
			if (getBinaryDir() != null)
			{
				preVerify.setOutputFolder(convertProjectRelativeLocationToIFolder(getBinaryDir()));
			}
			preVerify.performPreverify(targetPlatform);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.mtj.extension.bp.anttask.BuildProviderBaseAntTask#doExecute()
	 */
	public void run() {
		try {
			doRun (mtjProject, monitor);
		} catch (MtjException e) {
			throw new BuildException (e);
		} catch (CoreException e) {
			throw new BuildException (e);
		}

	}

	/**
	 * @return Returns the binaryDir.
	 */
	public String getBinaryDir() {
		return binaryDir;
	}

	/**
	 * @param binaryDir The binaryDir to set.
	 */
	public void setBinaryDir(String outputDir) {
		this.binaryDir = outputDir;
	}

	/**
	 * @return Returns the classesDir.
	 */
	public String getClassesDir() {
		return classesDir;
	}

	/**
	 * @param classesDir The classesDir to set.
	 */
	public void setClassesDir(String classesDir) {
		this.classesDir = classesDir;
	}

	
}
