/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.prep;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.ActionType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.ProprocessingProvider;
import org.eclipse.mtj.api.extension.impl.BuildExtensionImpl;
import org.eclipse.mtj.api.preprocessing.Condition;
import org.eclipse.mtj.exception.MtjException;

public class ProprocessingProviderImpl extends BuildExtensionImpl implements
		ProprocessingProvider {

	public static final String EXT_JAR_NAME = "preprocessor.jar"; //$NON-NLS-1$
	
	public ProprocessingProviderImpl() {
		super();
		
		setId("org.eclipse.mtj.extension.prep"); //$NON-NLS-1$
		setDescription(Messages.ProprocessingProviderImpl_PluginDescription);
		setVendor(Messages.ProprocessingProviderImpl_PluginVendor);
		setVersion(Messages.ProprocessingProviderImpl_PluginVersion);
		setType(ExtensionType.PREPROCESSING_PROVIDER_LITERAL);
		
		setExtJar(EXT_JAR_NAME);
	}

	public void process(IFolder sourceFolder, IFolder targetFolder,
			Condition[] conditions, IProgressMonitor monitor)
			throws MtjException {
		// TODO Auto-generated method stub

	}

	public String getCodeTemplate(ActionType actionType, Condition condition)
			throws MtjException {
		// TODO Auto-generated method stub
		return null;
	}

}
