/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.api.extension;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

public interface ProjectExtensionProvider {

	/**
	 * Method returns Project type that this extension is extending
	 *
	 * @return
	 */
	public ProjectType getProjectType();
	
	/**
	 * Return Project's Deployment -object. Value is null if the project hasn't got Deployment components.
	 * 
	 * @param project
	 * @return
	 */
	public Deployment getDeployment(IMtjProject project) throws MtjException;
	
	/**
	 * Return Project's Deployment -object that is targetted to the launchableApplication.
	 * 
	 * @param project
	 * @param launchableApplication
	 * @return
	 * @throws MtjException
	 */
	public Deployment getDeployment(IMtjProject project, String launchableApplication) throws MtjException;
	
	/**
	 * Returns deployment output folder
	 * 
	 * @param monitor
	 * @return
	 * @throws CoreException
	 */
	public String getDeploymentFolder(IProgressMonitor monitor) throws CoreException;
	
	/**
	 * Returns launchable classes output folder
	 * 
	 * @param monitor
	 * @return
	 * @throws CoreException
	 */
	public String getLaunchableClassesFolder(IProgressMonitor monitor) throws CoreException;

	/**
	 * Returns launchable libraries output folder
	 * 
	 * @param monitor
	 * @return
	 * @throws CoreException
	 */
	public String getLaunchableLibsFolder(IProgressMonitor monitor) throws CoreException;

	/**
	 * Return DeploymentType that the ProjectExtensionProvider is supporting
	 * 
	 * @return
	 * @throws MtjException
	 */
	public DeploymentType getDeploymentType() throws MtjException;

	/**
	 * Return IJavaSearchScope object for searching classes that support the project's scope
	 * 
	 * @param javaProject
	 * @return
	 * @throws MtjException
	 */
	public IJavaSearchScope getJavaSearchScope(IJavaProject javaProject) throws MtjException;

	/**
	 * Returns PreverificationPolicy that the project supports
	 * 
	 * @param targetPlatform
	 * @return
	 */
	public IPreverificationPolicy getPreverificationPolicy(RuntimePlatformDefinition targetPlatform) throws MtjException;
	
	/**
	 * Method initialized new Java Project project with the extension type -specific features
	 * 
	 * @param javaProject
	 * @throws MtjException
	 */
	public void initializeNewProject(IJavaProject javaProject, IProgressMonitor monitor) throws MtjException;
}
