/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.signings.SigningCertificate;
import org.eclipse.mtj.exception.MtjException;

/**
 * Signing Provider is responsible to sign projects different Deployment packages.
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:21 $
 * <br>
 */
public interface SigningProvider extends BuildExtension {

	/**
	 * Method returns whether the SingingProvider plug-in can provide 
	 * root certificate management features
	 * @return true if root certificate management features are available, false otherwise
	 * @throws MtjException
	 */
	public boolean isRootCertToolAvailable() throws MtjException;
	
	/**
	 * Method attempst to import keystore element (alias) into rootcert. Useses password to access keystore
	 * @param rootcert
	 * @param keystore
	 * @param alias
	 * @param password
	 * @throws MtjException
	 */
	public void importToRootCert(String rootcert, String keystore, String alias, String password)throws MtjException;
	/**
	 * Method returns string array populated with contents of rootcert
	 * @param rootcert
	 * @return
	 * @throws MtjException
	 */
	public String [] listrootcert(String rootcert) throws MtjException;
	/**
	 * Method attempts to remove entry from rootcert. References target entry by index (removeindex).
	 * @param rootcert
	 * @param removeindex
	 * @throws MtjException
	 */
	public void removeCertFromRoot(String rootcert, int removeindex) throws MtjException;
	/**
	 * Method returns the deployment types that are supported by itself.
	 * 
	 * @return
	 */
	public DeploymentType[] getSupportedTypes() throws MtjException;

	/**
	 * Method signs the project with the certificates.
	 * 
	 * @param project
	 * @param targetFolder
	 * @param certificates
	 * @param monitor
	 * @return
	 * @throws MtjException
	 */
	public boolean sign(IMtjProject project, IFolder targetFolder, SigningCertificate certificates, IProgressMonitor monitor) throws MtjException;
		
	/**
	 * Method unsigns the project
	 * 
	 * @param mtjProject
	 * @param targetFolder
	 * @param monitor
	 * @return
	 * @throws MtjException
	 */
	public boolean unsign(IMtjProject mtjProject, IFolder targetFolder, IProgressMonitor monitor) throws MtjException;
	 

	 /**
	  * Method determines and reports if deployment is signed
	  * 
	 * @param mtjProject
	 * @param targetFolder
	 * @param monitor
	 * @return
	 * @throws MtjException
	 */
	public boolean isSigned(IMtjProject mtjProject, IFolder targetFolder, IProgressMonitor monitor) throws MtjException;
	 	 
	 /**
	 * SigningProvider implementations that rely on an external security tool,
	 * are responsible for persistant storage of the tool location value.
	 * This method should return the location of the tool. Should never return null.
	 * @param monitor
	 * @return
	 * @throws MtjException
	 */
	public String getToolLocation(IProgressMonitor monitor) throws MtjException;
		
	 /**
	 * SigningProvider implementations that rely on an external security tool,
	 * are responsible for persistant storage of the tool location value. 
	 * @param loc
	 * @param monitor
	 * @throws MtjException
	 */
	public void storeToolLocation(String loc, IProgressMonitor monitor) throws MtjException;
		
}
