/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.util;

import java.util.ArrayList;
import java.io.File;
import java.io.IOException;

/**
 * This class provides static directory utility methods.
 */
public class DirUtil
{
    public static ArrayList getSubDirectoriesInDirectory (String path) throws IOException
    {
        ArrayList dirList = new ArrayList();

        File directory = new File(path);
        if (!directory.isDirectory())
        {
            return dirList;
        }

        String [] dirsAndFiles = directory.list();

        File testFile = null;
        for (int i = 0, length = dirsAndFiles.length; i < length; i++)
        {
            testFile = new File(path, dirsAndFiles[i]);
            if (testFile.isDirectory())
            {
				dirList.add(dirsAndFiles[i]);
            }
        }

        return dirList;
    }

    public static boolean fileExists (StringBuffer path)
    {
    	return fileExists(path.toString());
    }
    	
    public static boolean fileExists (String path)
    {
    	try {
	        File file = new File(path);
	        if (file.isFile())
	        {
		        return true;
	        }
	        else
	        {
		        return false;
	        }
    	}
    	catch (Exception e)
    	{
    		return false;
    	}
    }

    public static ArrayList getAllFilesInDirectory (String path, boolean recursive, boolean fullPath, String re) throws IOException
    {
    	return getAllFilesInDirectory (path, recursive, fullPath, new SimpleRegExp (re));
    }
    
    private static ArrayList getAllFilesInDirectory (String path, boolean recursive, boolean fullPath, SimpleRegExp re) throws IOException
    {
        ArrayList outta = new ArrayList();

        File directory = new File(path);
        if (!directory.isDirectory())
        {
            return outta;
        }

        String [] dirsAndFiles = directory.list();

        File testFile = null;
        for (int i = 0, length = dirsAndFiles.length; i < length; i++)
        {
            testFile = new File(path, dirsAndFiles[i]);
            if (testFile.isFile())
            {
                if (re.matches(dirsAndFiles[i]))
                {
                	if (fullPath)
                	{
	                    outta.add(path + '/' + dirsAndFiles[i]);
                	}
                	else
                	{
	                    outta.add(dirsAndFiles[i]);
                	}
                }
            }
            else
            {
                if (recursive)
                {
                    outta.addAll( getAllFilesInDirectory( new StringBuffer(64)
                                                          .append(path)
                                                          .append('/')
                                                          .append(dirsAndFiles[i]).toString()
                                                          , recursive
                                                          , fullPath
                                                          , re)
                                                          );
                }
            }
        }

        return outta;
    }

	private static class SimpleRegExp
	{
	    private String mask;
	
	    private int asteriskPosition;
	    private int dotPosition;
	    private boolean matchWord;
	    private boolean allMatches;
	
	    String beginsWith = null;
	    String endsWith = null;
	
	    public SimpleRegExp(String mask)
	    {
	        this.mask = mask;
	        calculatePositions();
	    }
	
	    public void setMask (String x)
	    {
	        mask = x;
	        calculatePositions();
	    }
	
	    public String getMask ()
	    {
	        return mask;
	    }
	
	    public boolean matches(String str)
	    {
	        if (allMatches)
	        {
	            return true;
	        }
	        else if (matchWord)
	        {
	            return mask.equals(str);
	        }
	        else
	        {
	            boolean retVal = false;
	            if (beginsWith != null)
	            {
	                retVal = str.startsWith(beginsWith);
	                if (!retVal)
	                {
	                    return retVal;
	                }
	                else
	                {
	                    if (endsWith != null)
	                    {
	                        return str.endsWith(endsWith);
	                    }
	                    else
	                    {
	                        return true;
	                    }
	                }
	            }
	            else
	            {
	                if (endsWith != null)
	                {
	                    return str.endsWith(endsWith);
	                }
	                else
	                {
	                    return true;
	                }
	            }
	        }
	    }
	
	    private void calculatePositions()
	    {
	
	        if (mask == null || mask.length() == 0)
	        {
	            throw new IllegalArgumentException("SimpleRegExp::calculatePositions mask == null || mask.length() == 0"); //$NON-NLS-1$
	        }
	
	        if (mask.equals("*.*")) //$NON-NLS-1$
	        {
	            allMatches = true;
	            return;
	        }
	
	        dotPosition = mask.lastIndexOf('.');
	
	        asteriskPosition = mask.indexOf('*');
	
	        if (asteriskPosition == -1)
	        {
	            matchWord = true;
	            return;
	        }
	        else
	        {
	            if (mask.endsWith("*.*")) //$NON-NLS-1$
	            {
	                beginsWith = mask.substring(0, asteriskPosition);
	                endsWith = null;
	            }
	            else
	            {
	                if (asteriskPosition < dotPosition)
	                {
	                    beginsWith = mask.substring(0, asteriskPosition);
	                    endsWith = mask.substring(dotPosition);
	                }
	                else
	                {
	                    beginsWith = mask.substring(0, dotPosition);
	                    endsWith = mask.substring(asteriskPosition);
	                }
	            }
	        }
	    }
	}	
	
	public static String getFileExtension(String file) {
		if (file.indexOf(".") != -1) { //$NON-NLS-1$
			return file.substring(file.lastIndexOf(".")+1); //$NON-NLS-1$
		}
		
		return ""; //$NON-NLS-1$
	}
}
