/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;


import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.mtj.jad.util.SynchronizeManifestFileToJad;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/**
 * MidletSuitePackagingWizardPage.java 2006 Mar 1, 2006 2:21:51 PM @author khorowit
 *
 */
public class MidletSuitePackagingWizardPage extends WizardPage {

	IProject project = null;
	JadFileDescriptor jadFile;
	MidletSuiteSectionRequired requiredSection = null;
	
	/**
	 * A constructor for MidletSuitePackagingWizardPage.java
	 * @param pageName
	 */
	public MidletSuitePackagingWizardPage(String pageName, JadFileDescriptor jadFile) {
		super(pageName);
		// TODO Auto-generated constructor stub
		this.jadFile = jadFile;
		setImageDescriptor(MtjDevIdePlugin.getImageDescriptor("icons/full/wiz/jad_file_wiz.png")); //$NON-NLS-1$
	}
	
	/**
	 * A constructor for MidletSuitePackagingWizardPage.java
	 * @param pageName
	 */
	public MidletSuitePackagingWizardPage(String pageName, JadFileDescriptor jadFile, IProject project) {
		super(pageName);
		// TODO Auto-generated constructor stub
		this.jadFile = jadFile;
		this.project = project;
		setImageDescriptor(MtjDevIdePlugin.getImageDescriptor("icons/full/wiz/jad_file_wiz.png")); //$NON-NLS-1$
	}
	

	/**
	 * A constructor for MidletSuitePackagingWizardPage.java
	 * @param pageName
	 * @param title
	 * @param titleImage
	 */
	public MidletSuitePackagingWizardPage(String pageName, String title,
			ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
		jadFile = JadFileDescriptor.getDescriptor();
		setImageDescriptor(MtjDevIdePlugin.getImageDescriptor("icons/full/wiz/jad_file_wiz.png")); //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
	
		setTitle (Messages.MidletSuitePackagingWizardPage_Configure_midlet_suite);
		setDescription(Messages.MidletSuitePackagingWizardPage_Configure_application_package);
		FormToolkit toolkit = new FormToolkit(parent.getDisplay());
		ScrolledForm form = toolkit.createScrolledForm(parent);
//		ColumnLayout layout = new ColumnLayout();
//		layout.maxNumColumns = 1;
	
		GridLayout gdLayout = new GridLayout();
		form.getBody().setLayout(gdLayout);
//		form.getBody().setLayout(layout);

		requiredSection = new MidletSuiteSectionRequired(jadFile, form.getBody(), toolkit,  Section.DESCRIPTION|Section.TITLE_BAR);
//		MidletSuiteSectionMidlet midletSection = new MidletSuiteSectionMidlet(jadFile, project, form.getBody(), toolkit,  Section.DESCRIPTION|Section.TITLE_BAR);
			
		setControl(form);

	}
	
	@Override
	public boolean isPageComplete() {
//		if (project == null)
//			return false;
		
		return super.isPageComplete();
	}
	@Override
	public Control getControl() {

		if (project != null && requiredSection != null)
			requiredSection.initializeData(project.getName());
		
		return super.getControl();
	}
	
	public void setProject (IProject project)
	{
		this.project = project;
	}
	
	public void setProjectName (String projectName)
	{
		requiredSection.initializeData(projectName);
	}
	
	public void doFinish ()
	{
		
		jadFile = requiredSection.getJadFile();
		IFile jadIFile = project.getFile(project.getName().replace(' ','_') + ".jad"); //$NON-NLS-1$
		
		try 
		{
			IProgressMonitor pm = new NullProgressMonitor();
			jadFile.serialize(jadIFile, pm);

			// Create a Manifest file that reflects the data in the jad file during creation
			SynchronizeManifestFileToJad info = new SynchronizeManifestFileToJad (jadIFile);
			info.run(pm);
		}
		catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e1) {
			e1.printStackTrace();
		}  catch (CoreException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	

}
