/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;

public class MTJLibrarySelectionWizard extends Wizard {
	
	private IStructuredSelection selected;
	IProject project;
	MTJNewProjectSelectLibraryWizardPage libraryWizardPage;
	
	public MTJLibrarySelectionWizard(IStructuredSelection selected) {
		this.selected = selected;
		
		Object ob = selected.getFirstElement();
		if (ob instanceof IProject)
			project = (IProject) ob;
		if (ob instanceof IFile)
		{
			IFile projectResource = (IFile) ob;
			project = projectResource.getProject();
		}

	}
	
	public IStructuredSelection getSelected() {
		return selected;
	}
	
	public void addPages() {
		libraryWizardPage = new MTJNewProjectSelectLibraryWizardPage("", project); //$NON-NLS-1$
		addPage(libraryWizardPage);
	}

	public boolean performFinish() {
		
		// Need to make sure that the classpath is already set?
		
		IProgressMonitor pm = new NullProgressMonitor();

		TargetDevice[] projectModelData = libraryWizardPage.getProjectModelData();
		IJavaProject javaProject = JavaCore.create (project);

		try {
			MtjProject mtjProject = (MtjProject) MtjProject.getMtjProject(javaProject);

			Project model = mtjProject.getProjectData ();

			model.setDefaultTargetDevice(projectModelData[0]);
			
			mtjProject.setProjectData(model);

			mtjProject.addClasspathContainerIfMissing(pm);
		} catch (MtjException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (CoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		
		return true;
	}

}
