/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.util.Calendar;
import java.util.HashMap;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.core.util.MtjEmfUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.extension.devide.core.J2MEClasspathContainer;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.model.RpmUIManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MTJNewProjectSelectLibraryWizardPage extends WizardPage implements IClasspathContainerPage {

	Combo swt_combo_type;
	
	HashMap rpMap;
	public IClasspathEntry fSelection;
	public IProject project;
	static Calendar calendarReference = null;
	
	private static final String RPM_PREFERENCES_ID = "org.eclipse.mtj.extension.rpm.preferences.RpmPreferencePage"; //$NON-NLS-1$
	private static final String DM_PREFERENCES_ID = "org.eclipse.mtj.extension.dm.preferences.DmPreferencePage"; //$NON-NLS-1$
	private static final String SECURITY_PREFERENCES_ID = "org.eclipse.mtj.extension.smgmt.ui.eclipse.preferences.SecurityManagementPreferencePage"; //$NON-NLS-1$
	private static final String SIGNING_PREFERENCES_ID = "org.eclipse.mtj.extension.sp.ui.eclipse.preferences.SigningPreferencePage"; //$NON-NLS-1$

	// Use to handle IClasspathContainerPage
	public MTJNewProjectSelectLibraryWizardPage() {
		super(""); //$NON-NLS-1$
	}
	
	// Initialized through new project wizard
	public MTJNewProjectSelectLibraryWizardPage(String pageName) {
		super(pageName);
	}
	
	// Initialized through library selection wizard
	public MTJNewProjectSelectLibraryWizardPage(String pageName, IProject projectReference) {
		super(pageName);
		project = projectReference;
	}
	
	public void setLabels ()
	{
		setTitle(Messages.MTJNewProjectSelectLibraryWizardPage_MTJ_JavaMe_library_addition); 
		setDescription(Messages.MTJNewProjectSelectLibraryWizardPage_Select_appropriate_SDK); 
		setImageDescriptor(MtjDevIdePlugin.getImageDescriptor("icons/full/wiz/add_edit_device_platform_mgmt_wiz.png")); //$NON-NLS-1$		
		// setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		setLabels ();
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Label referenceLabel = new Label(composite, SWT.NONE);
		referenceLabel.setText(Messages.MTJNewProjectSelectLibraryWizardPage_Select_runtime_platform);

		swt_combo_type = new Combo(composite, SWT.DROP_DOWN | SWT.BORDER | SWT.READ_ONLY);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 4;
		addRuntimePlatforms();
		swt_combo_type.setLayoutData(gd);
		swt_combo_type.addSelectionListener(
				new SelectionListener() {
					public void widgetSelected(SelectionEvent e) {
			            setPageComplete(isPageComplete());
					}
					public void widgetDefaultSelected(SelectionEvent e) {}
				}
		);
		
		Composite c = new Composite(composite, SWT.NONE);
		GridLayout layout = new GridLayout(2, false);
		c.setLayout(layout);
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);
		c.setLayoutData(data);

		 
		Link lnkConfigure = new Link(composite, SWT.NONE);
		gd = new GridData(SWT.BEGINNING, SWT.FILL, true, false);
		lnkConfigure.setLayoutData(gd);
		lnkConfigure.setText(Messages.MTJNewProjectSelectLibraryWizardPage_Configure_runtime_platform_link);
		lnkConfigure.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
		    	openPreferences();
				addRuntimePlatforms();
				setPageComplete (isPageComplete());

			}
		
			public void widgetDefaultSelected(SelectionEvent e) {
				openPreferences();
				addRuntimePlatforms();
				setPageComplete (isPageComplete());

			}
		});
		
		/*
		Button addButton = new Button(c, SWT.PUSH);
		addButton.setFont(parent.getFont());
		addButton.setText(Messages.MTJNewProjectSelectLibraryWizardPage_New_runtime_platform);
		addButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				addNewRuntimePlatform();
			}
		});

		Button openButton = new Button(c, SWT.PUSH);
		openButton.setFont(parent.getFont());
		openButton.setText(Messages.MTJNewProjectSelectLibraryWizardPage_Open_Selected);
		openButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				openRuntimePlatform();
			}
		});
		*/
		setControl(composite);
	}
	
	private void openPreferences() {
		String[] preferencePages = new String [] {
					RPM_PREFERENCES_ID, 
					DM_PREFERENCES_ID, 
					SECURITY_PREFERENCES_ID, 
					SIGNING_PREFERENCES_ID};
		
			PreferenceDialog prefdlg = PreferencesUtil.createPreferenceDialogOn(
					Display.getCurrent().getActiveShell(),
					RPM_PREFERENCES_ID, 
					preferencePages, 
					null);
			prefdlg.open();
	}
	
	private void openRuntimePlatform() {
		if ( getRuntimePlatform() != null ) {
			RpmUIManager.editRuntimePlatform(getRuntimePlatform(), getShell());

			/*
			EditRuntimeDialog dialog = new EditRuntimeDialog(getShell(),
					"Edit And Configure Mobile Runtime Platform", getRuntimePlatform());
			dialog.setBlockOnOpen(true);

			if (dialog.open() == Dialog.OK) {
				
			}
			*/
		}
	}
	
	/**
	 * Add existing RuntimePlatform to the selection Combo
	 * 
	 */
	private void addRuntimePlatforms() {
		swt_combo_type.removeAll();
		RuntimePlatform[] rps = (new MtjServiceHandler()).getRuntimePlatforms(); //(RuntimePlatform[])RpmUtils.getRuntimePlatforms();
		rpMap = new HashMap();
		if ( rps != null ) {
			for (int i = 0; i < rps.length; i++) {
				String name = rps[i].getName() + " - " + rps[i].getDescription(); //$NON-NLS-1$
				swt_combo_type.add(name);
				rpMap.put(name, rps[i]);
				//RJP
				swt_combo_type.select(i);
			}
		}
	}

	private void addNewRuntimePlatform() {
		if(RpmUIManager.addRuntimePlatform(getShell(), true) == Dialog.OK) {
			addRuntimePlatforms();
			setPageComplete (isPageComplete());
		}		
	}

	@Override
	public boolean isPageComplete() {
		return isRuntimePlatformInDialog();
	}
	
	/**
	 * Provide a way to determine if there is a runtime in the selection widget without having to 
	 * query the runtimes unnessisarily.
	 * @return true or false
	 */
	private boolean isRuntimePlatformInDialog() {
		 if (swt_combo_type.getText() != null && swt_combo_type.getText().compareTo("") != 0) //$NON-NLS-1$
			 return true;
		 else
			 return false;
	}
	
	private RuntimePlatform getRuntimePlatform() {
		return (RuntimePlatform)rpMap.get(swt_combo_type.getText());
	}
	
	public TargetDevice[] getProjectModelData ()
	{
		RuntimePlatform rp = getRuntimePlatform();
		EList list = rp.getTargetDevices();
		TargetDevice[] tds = new TargetDevice[list.size()];
		for (int i = 0; i < list.size(); i++) {
			tds[i] = (TargetDevice)MtjEmfUtil.clone((TargetDevice)list.get(i));
		}
		return tds;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.ui.wizards.IClasspathContainerPage#finish()
	 */
	public boolean finish() {
		setSelection (createSelection());
		TargetDevice[] targetDevice = getProjectModelData();
		
		Project project = ProjectFactory.eINSTANCE.createProject();
		
		if ( targetDevice != null && targetDevice.length > 0 ) {
			project.setDefaultTargetDevice(targetDevice[0]);
		}
		if ( targetDevice != null && targetDevice.length > 1 ) {
			for (int i = 1; i < targetDevice.length; i++) {
				project.getTargetDevices().add(targetDevice[i]);
			}
		}
		try {
			// CalendarReference should have been initialized already
			String timeInMillis = Long.toString(calendarReference.getTimeInMillis());
			IPath location = MtjProject.getMetadataTemporaryStorage(timeInMillis);
			MtjProject.setProjectDataTemporaryLocation(project, location );
		} catch (MtjException e) {
			e.printStackTrace();
		}	
		return true;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jdt.ui.wizards.IClasspathContainerPage#getSelection()
	 */
	public IClasspathEntry getSelection() {
			System.out.println (Messages.MTJNewProjectSelectLibraryWizardPage_8);
//			return createNormalSelection();
				return fSelection;
		}
	
	/**
	 * This creates a special classpath entry for a J2ME_Container that has an additional unique path.
	 * This is used for cases where the project data needs to be written outside of the project.
	 * This condition occurs when the wizard is launched from the Build Properties page instead of
	 * from the project or project creation.
	 * @return
	 */
	public IClasspathEntry createSelection() {
		if (fSelection != null)
			return fSelection;
		
		if (calendarReference == null)
			calendarReference =  Calendar.getInstance();
		IPath entryPath =
			new Path(J2MEClasspathContainer.J2ME_CONTAINER);

		String timeInMillis = Long.toString(calendarReference.getTimeInMillis());

		entryPath = entryPath.append(timeInMillis);
		IClasspathEntry newEntry =
			JavaCore.newContainerEntry(entryPath);

		return newEntry;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.ui.wizards.IClasspathContainerPage#setSelection(org.eclipse.jdt.core.IClasspathEntry)
	 */
	public void setSelection(IClasspathEntry containerEntry) {
		fSelection = containerEntry;
	}
	
}
