/*******************************************************************************
* Copyright (c) 2000, 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.ui.constants.ProjectCreationConstants;
import org.eclipse.mtj.core.ui.model.ProjectCreationModel;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class MTJNewProjectWizard extends BasicNewProjectResourceWizard implements IExecutableExtension {
	protected MTJNewProjectWizardPage fJavaPage;
	protected WizardNewProjectCreationPage fMainPage;
	protected MTJNewProjectSelectLibraryWizardPage fJavaSDKPage;
	protected IConfigurationElement fConfigElement;
	protected MTJNewProjectTemplatePage fTemplatesPage;

	public ProjectCreationModel projectModel = new ProjectCreationModel();
	
	public MTJNewProjectWizard() {
		super();
		projectModel.setProperty(ProjectCreationConstants.PCC_NATURE, MtjNature.getNatureID());
	}

	protected void createMainPage() {
		fMainPage= new ProjectCreationPage("id");  //$NON-NLS-1$
		
		String msg = Messages.MTJNewProjectWizard_JavaME_Project_creation;
		fMainPage.setTitle(msg);
		
		msg = Messages.MTJNewProjectWizard_Create_JavaME_Project;
		fMainPage.setDescription(msg);
	}
	
	/**
	 * Gets the mainPage.
	 * @return Returns a WizardNewProjectCreationPage
	 */
	public WizardNewProjectCreationPage getMainPage() {
		return fMainPage;
	}

	protected void createJavaPage(MTJNewProjectSelectLibraryWizardPage javaSDKPage) {
		fJavaPage= new MTJNewProjectWizardPage(ResourcesPlugin.getWorkspace().getRoot(), fMainPage, projectModel, javaSDKPage, null);
		fJavaPage.setForMidp(false);
	}
	
	/**
	 * Gets the javaPage.
	 * @return Returns a NewJavaProjectWizardPage
	 */
	public MTJNewProjectWizardPage getJavaPage() {
		return fJavaPage;
	}

	protected void createJavaSDKPage() {
		fJavaSDKPage = new MTJNewProjectSelectLibraryWizardPage(Messages.MTJNewProjectWizard_Select_device_and_libraries);

		String msg = Messages.MTJNewProjectWizard_MTJ_Project_creation;
		fJavaSDKPage.setTitle(msg);

		msg = Messages.MTJNewProjectWizard_Select_Device_and_libraries_2;
		fJavaSDKPage.setDescription(msg);
	}
	
	/**
	 * Allow a subclass to mofify the pages at this point
	 *
	 */
	protected void createOptionalPages()
	{
		createTemplatesPage();
	}
	
	protected void createTemplatesPage() {
		fTemplatesPage = new MTJNewProjectTemplatePage(false);
	}
	/**
	 * Allow a subclass to mofify the pages at this point
	 *
	 */
	protected void addOptionalPages()
	{	
		addPage(fTemplatesPage);
	}
	
	/**
	 * Gets the Libraries Container Page.
	 * @return Returns a MTJNewProjectSelectLibraryWizardPage
	 */
	public MTJNewProjectSelectLibraryWizardPage getJavaSDKPage() {
		return fJavaSDKPage;
	}

	/**
	 * @see Wizard#addPages
	 */	
	public void addPages() {
		
		createMainPage();
		createJavaSDKPage();
		createJavaPage(getJavaSDKPage());
		createOptionalPages ();
		
		addPage(fMainPage);
		addPage(fJavaSDKPage);
		addPage(fJavaPage);
		addOptionalPages();
	}		
	
    public boolean performCancel() {
        return true;
    }
    
	/**
	 * @see Wizard#performFinish
	 */		
	public boolean performFinish() {
//		if (fJavaSDKPage != null)
//			fJavaSDKPage.updateBuildpath();
	 
		boolean result = false;
		try{
		RunnableActionExecutor executor = new RunnableActionExecutor(Messages.MTJNewProjectWizard_Create_MTJ_Midlet_project); 
		IRunnableWithProgress projectAction = new ProjectCreationAction(fJavaPage, fJavaSDKPage, null, fTemplatesPage, projectModel, getShell());
//		IRunnableWithProgress buildfileAction = new BuildfileCreationAction(fMainPage.getProjectHandle());
		
		executor.addAction(new RunnableAction(projectAction, ProjectCreationAction.NAME, 10));
//		executor.addAction(new RunnableAction(buildfileAction, BuildfileCreationAction.NAME, 5));
		 result = executor.runWithDialog(getShell());

		}
		catch (NullPointerException e)
		{
		 e.printStackTrace();
		}
		
		BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
		
		return result;
	}
		
	/* (non-Javadoc)
	 * Method declared on IWorkbenchWizard.
	 */
	public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
		super.init(workbench, currentSelection);
		initializeDefaultPageImageDescriptor();
		setWindowTitle(Messages.MTJNewProjectWizard_New_Project); 
	}

	/**
	 * Stores the configuration element for the wizard.  The config element will be used
	 * in <code>performFinish</code> to set the result perspective.
	 */
	public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
		fConfigElement= cfig;
				
		initializeDefaultPageImageDescriptor();
	}
	
	protected void initializeDefaultPageImageDescriptor() {
//		setDefaultPageImageDescriptor(J9PluginImages.DESC_WIZBAN_ME_PROJ);
	}	

	public String getProjectName ()
	{
		return getJavaPage().getProjectName();
	}
	
	public IProject getProject ()
	{
		return getJavaPage().getProject();
	}



}