/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.dialog;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIPlugin;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersContentProvider;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeploymentManagementDialog extends TitleAreaDialog {
	private DeploymentManagementDialog dplmDialog = this;
	private String strSelResource = ""; //$NON-NLS-1$
	private Shell shell;
	private Button btnResourceBrowse, btnRefresh, btnProperties, btnDeploy, btnSelectProject, btnClose;
	private Label lblResource, lblDescription, lblSelectedProject;
	private Text txtResourceFile;    
    protected Combo cboProtocol;
	private String[] resourceFilterExt = null; //{ "*.jar; *.sis; *.res; *" };
	private CheckboxTreeViewer deviceViewer;
    private ProvidersContentProvider contentProvider = new ProvidersContentProvider();    
    private ProvidersLabelProvider labelProvider;    
    private Object selectedResource;
	private IJavaProject javaProject;	
	private List<Device> selectedDevices = new Vector<Device>();	
	private IProgressMonitor monitor = null;

	/**
	 * The constructor
	 */
	public DeploymentManagementDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE);

		labelProvider = new ProvidersLabelProvider();
		/*
		MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_MANAGEMENT_LITERAL, null,	null);
		if(list.length > 0) {
			labelProvider = new ProvidersLabelProvider((DeploymentManagement) list[0]);
		}
		*/
	}

	protected Control createDialogArea(Composite parent) {

	    // TODO: replace static strings
        
        shell = this.getShell();
        Image image = DeploymentManagementUIPlugin.getImageDescriptor("icons/phone.gif").createImage(); //$NON-NLS-1$
        shell.setImage(image);
        
		Composite result = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(result, SWT.NONE);
		container.setLayoutData(new GridData(GridData.FILL_BOTH));
		this.setTitle(DeploymentManagementUIMessages.DeploymentManagementDialog_DialogTitle);
		setMessage(DeploymentManagementUIMessages.DeploymentManagementDialog_DialogDescription);
		this.setTitleImage(DeploymentManagementUIPlugin.getImageDescriptor("/icons/deploy.gif").createImage()); //$NON-NLS-1$
        
		GridLayout gridLayout = new GridLayout();
		container.setLayout(gridLayout);
        gridLayout.numColumns = 6;
        gridLayout.marginHeight = 12;
        gridLayout.marginWidth = 12;
        gridLayout.verticalSpacing = 7;

        lblResource = new Label(container, SWT.NONE);
		GridData gd = new GridData(SWT.FILL, SWT.FILL, false, false);
		lblResource.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Resource);
		lblResource.setLayoutData(gd);

		txtResourceFile = new Text(container, SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 4;
		txtResourceFile.setLayoutData(gd);
		txtResourceFile.setEditable(false);
		txtResourceFile.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				strSelResource = txtResourceFile.getText();
			}
		});

		class OpenResource implements SelectionListener {
			public void widgetSelected(SelectionEvent event) {
				FileDialog fileDialog = new FileDialog(shell, SWT.OPEN);
				// TODO replace static strings
				fileDialog
						.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToBeDeployed); 
				fileDialog.setFilterPath(ResourcesPlugin.getWorkspace()
						.getRoot().getLocation().toOSString());
				fileDialog.setFilterExtensions(resourceFilterExt);
				if (strSelResource != "") //$NON-NLS-1$
					fileDialog.setFileName(strSelResource);
				if (fileDialog.open() != null) {
					String separator = ""; //$NON-NLS-1$
					int length = fileDialog.getFilterPath().trim().length();
					if (length > 0
							&& fileDialog.getFilterPath().charAt(length - 1) != File.separatorChar)
						separator = File.separator;
					strSelResource = new Path(fileDialog.getFilterPath() + separator
							+ fileDialog.getFileName()).toOSString();
					txtResourceFile.setText(strSelResource);
					btnDeploy.setEnabled(true);
					updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeploysResourceOnDevice, false);
				}
				txtResourceFile.setFocus();
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		}

		btnResourceBrowse = new Button(container, SWT.NONE);
		initializeDialogUnits(btnResourceBrowse);
		setButtonLayoutData(btnResourceBrowse);
		btnResourceBrowse.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Browse);
		btnResourceBrowse.addSelectionListener(new OpenResource());	        

        Label separator = new Label(container, SWT.SEPARATOR | SWT.HORIZONTAL);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.horizontalSpan = 6;
        gd.verticalIndent = 3;
        separator.setLayoutData(gd);
        
        Composite deviceListArea = new Composite(container, SWT.NULL);
        gd = new GridData(GridData.FILL_BOTH);
        gd.heightHint = 300;
        gd.widthHint = 200;
        gd.horizontalSpan = 3;
        deviceListArea.setLayoutData(gd);
     
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        deviceListArea.setLayout(gridLayout);
        
        Group grpDevices = new Group(deviceListArea, SWT.NONE);
        grpDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Devices); 
        gd = new GridData(GridData.FILL_BOTH);
        grpDevices.setLayoutData(gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpDevices.setLayout(gridLayout);
        
        Composite deviceTreeArea = new Composite(grpDevices, SWT.NULL);
        FillLayout layout2 = new FillLayout();
        deviceTreeArea.setLayout(layout2);
        gd = new GridData(GridData.FILL_BOTH);
        deviceTreeArea.setLayoutData(gd);
        
        deviceViewer = new CheckboxTreeViewer(deviceTreeArea);
        addDeviceViewerListeners(deviceViewer);
        
        deviceListArea = new Composite(container, SWT.NULL);
        gd = new GridData(GridData.FILL_BOTH);
        gd.heightHint = 300;
        gd.horizontalSpan = 3;
        deviceListArea.setLayoutData(gd);
     
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        deviceListArea.setLayout(gridLayout);
        
        Group grpDescription = new Group(deviceListArea, SWT.NONE);
        grpDescription.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Description); 
        gd = new GridData(GridData.FILL_BOTH);
        gd.horizontalSpan = 2;
        gd.heightHint = 130;
        grpDescription.setLayoutData(gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpDescription.setLayout(gridLayout);
     
        lblDescription = new Label(grpDescription, SWT.WRAP);
        gd = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL | GridData.VERTICAL_ALIGN_FILL
                | GridData.GRAB_VERTICAL);
        gd.widthHint = 300;
        lblDescription.setLayoutData(gd);
     
        Group grpFilterDevices = new Group(deviceListArea, SWT.NONE);
        grpFilterDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_DevicesFilter); 
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.heightHint = 50;
        grpFilterDevices.setLayoutData(gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpFilterDevices.setLayout(gridLayout);
        
        Button rbtnPrjDevices = new Button(grpFilterDevices, SWT.RADIO);
        rbtnPrjDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_ComptibleDevices);
        rbtnPrjDevices.setSelection(true);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        rbtnPrjDevices.setLayoutData(gd);
        
        Button rbtnAllDevices = new Button(grpFilterDevices, SWT.RADIO);
        rbtnAllDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_AllDevices);
        //rbtnAllDevices.setSelection(true);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        rbtnAllDevices.setLayoutData(gd);
       
        Group grpFilterConnected = new Group(deviceListArea, SWT.NONE);
        grpFilterConnected.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_StatusFilter); 
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.heightHint = 50;
        grpFilterConnected.setLayoutData(gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpFilterConnected.setLayout(gridLayout);
        
        Button rbtnConnectedDevices = new Button(grpFilterConnected, SWT.RADIO);
        rbtnConnectedDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_OnlyConnectedDevices);
        rbtnConnectedDevices.setSelection(true);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.horizontalSpan = 3;
        rbtnConnectedDevices.setLayoutData(gd);
     
        Button rbtnAlsoDisconnectedDevices = new Button(grpFilterConnected, SWT.RADIO);
        rbtnAlsoDisconnectedDevices.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_AllDevices);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.horizontalSpan = 2;
        rbtnAlsoDisconnectedDevices.setLayoutData(gd);
        
        addRbtnFiltersListeners(rbtnConnectedDevices, rbtnAlsoDisconnectedDevices, rbtnPrjDevices, rbtnAllDevices);
        
        // TODO protocol filtering implemented later on
        /*        
        Group grpFilterProtocol = new Group(deviceListArea, SWT.NONE);
        grpFilterProtocol.setText("Protocol filter"); 
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.heightHint = 50;
        gd.horizontalSpan = 4;
        grpFilterProtocol.setLayoutData(gd);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpFilterProtocol.setLayout(gridLayout);
        
        cboProtocol = new Combo(grpFilterProtocol, SWT.READ_ONLY | SWT.BORDER
                | SWT.SINGLE);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        cboProtocol.setLayoutData(gd);
        cboProtocol.setVisibleItemCount(10);
        // TODO get real protocols
        //cboProtocol.setItems(getProtocols());
        String[] items = {"Project default protocol", "All protocols", "Protocol 1", "Protocol 2", "Protocol 3", "Protocol 4"};
        cboProtocol.setItems(items);
        cboProtocol.select(0);
        addProtocolSelectionListener(cboProtocol);
        //cboProtocol.addListener(SWT.Selection, this);
 */       
        Group grpSelectedProject = new Group(deviceListArea, SWT.NONE);
        grpSelectedProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Project); 
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.horizontalSpan = 2;
        gd.heightHint = 40;
        grpSelectedProject.setLayoutData(gd);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 7;
        gridLayout.marginWidth = 9;
        gridLayout.verticalSpacing = 7;
        grpSelectedProject.setLayout(gridLayout);
     
        lblSelectedProject = new Label(grpSelectedProject, SWT.WRAP);
        gd = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL | GridData.VERTICAL_ALIGN_FILL
                | GridData.GRAB_VERTICAL);
        lblSelectedProject.setLayoutData(gd);
        selectedResource = getSelectedResource();
        
        btnSelectProject = new Button(grpSelectedProject, SWT.NONE);
        initializeDialogUnits(btnSelectProject);
        setButtonLayoutData(btnSelectProject);
        btnSelectProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Change);
        addBtnSelectProjectListeners(btnSelectProject);
        
        btnProperties = new Button(container, SWT.NONE);
        initializeDialogUnits(btnProperties);
        setButtonLayoutData(btnProperties);
        btnProperties.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Properties);
        addBtnPropertiesListeners(btnProperties);
        
        btnRefresh = new Button(container, SWT.NONE);
        initializeDialogUnits(btnRefresh);
        setButtonLayoutData(btnRefresh);
        btnRefresh.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Refresh); 
        addBtnRefreshListeners(btnRefresh);
		
        // Dummy label to fill a column
        Label label = new Label(container, SWT.NONE);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.horizontalSpan = 1;
        label.setLayoutData(gd);

        // Dummy label to fill a column
        label = new Label(container, SWT.NONE);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.horizontalSpan = 2;
        label.setLayoutData(gd);
        
		btnDeploy = new Button(container, SWT.NONE);
		initializeDialogUnits(btnDeploy);
		setButtonLayoutData(btnDeploy);
        btnDeploy.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_Deploy); 
        addBtnDeployListeners(btnDeploy);

        // Dummy separator
        separator = new Label(container, SWT.SEPARATOR
                | SWT.HORIZONTAL);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        gd.horizontalSpan = 6;
        gd.verticalIndent = 3;
        separator.setLayoutData(gd);

        // set content and label providers for the providers-devices tree viewer
        contentProvider.setFilters(DialogConstants.COMPATIBLE_DEVICES, DialogConstants.CONNECTED_DEVICES, DialogConstants.PROJECT_DEFAULT_PROTOCOL);
        // contentProvider.setDeploymentManagement((DeploymentManagement) list[0]);
        deviceViewer.setContentProvider(contentProvider);
        deviceViewer.setLabelProvider(labelProvider);
        
        List<DeploymentProvider> providersList = new Vector<DeploymentProvider>();
        MtjExtension[] providers = MtjServices.getInstance().getImplementations(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);
        for(int i=0; i<providers.length; i++){
        	providersList.add((DeploymentProvider) providers[i]);
        }
        
        deviceViewer.setInput(providersList);
        setResourceFields(selectedResource);
        
        //StatusLineManager statusLineManager = new StatusLineManager();
        //statusLineManager.createControl(result);
        //this.monitor = statusLineManager.getProgressMonitor();
        
		return result;
	}

	private void addBtnSelectProjectListeners(Button btnSelectProject) {
		btnSelectProject.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e) {
				javaProject = selectProject();
				setResourceFields(javaProject);
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
			
		});        
		
	}

	private IJavaProject selectProject() {
		IJavaProject[] projects;
		try {
			projects= JavaCore.create(ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
		} catch (JavaModelException e) {
			projects= new IJavaProject[0];
		}
		
		ILabelProvider labelProvider= new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
		ElementListSelectionDialog dialog= new ElementListSelectionDialog(getShell(), labelProvider);
		dialog.setTitle(DeploymentManagementUIMessages.DeploymentManagementDialog_ProjectSelection); 
		dialog.setMessage(DeploymentManagementUIMessages.DeploymentManagementDialog_ChooseTheProject); 
		dialog.setElements(projects);
		dialog.setInitialSelections(new Object[] { this.javaProject });
		if (dialog.open() == Window.OK) {			
			return (IJavaProject) dialog.getFirstResult();
		}			
		return null;		
	}

	private void setResourceFields(Object selectedResource) {
		IMtjProject mtjProject = null;
		
		if(selectedResource instanceof IJavaProject){			
			try {
				this.javaProject = (IJavaProject)selectedResource;
				mtjProject = MtjProject.getMtjProject(javaProject);
			} catch (MtjException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();				
			}
			if(mtjProject == null){
				updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
			}else{			
				updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeploysOnDevice, false);
				btnDeploy.setEnabled(false);
			}
	        contentProvider.setJavaProject(this.javaProject);
	        try {
	        	MidletDeployment midlet = null;
				if(mtjProject != null){
					midlet = (MidletDeployment)mtjProject.getDeployment();		        	
			        lblSelectedProject.setText(mtjProject.getProject().getName());
				}else{
					lblSelectedProject.setText(((IJavaProject)selectedResource).getPath().toString());
				}
				if(midlet != null){
					txtResourceFile.setText(midlet.getJad().getName());
					btnDeploy.setEnabled(true);
				}else{
					txtResourceFile.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy);
		        	txtResourceFile.selectAll();
		        	btnDeploy.setEnabled(false);
				}
			} catch (CoreException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	        

        }else if(selectedResource instanceof IProject){
        	lblSelectedProject.setText(((IProject)selectedResource).getFullPath().toString());
        	txtResourceFile.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy);	
           	txtResourceFile.selectAll();
        }else if(selectedResource instanceof IResource){
        	IResource resource = (IResource) selectedResource;
        	IProject container = resource.getProject();
        	javaProject = JavaCore.create(container);

        	if(javaProject != null){
    			try {
    				mtjProject = MtjProject.getMtjProject(javaProject);
    			} catch (MtjException e) {
    				// TODO Auto-generated catch block
    				e.printStackTrace();				
    			}
    			if(mtjProject == null){
    				updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
    			}else{			
    				updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_DeployeToDevice, false);
    				btnDeploy.setEnabled(false);
    			}
    	        contentProvider.setJavaProject(this.javaProject);        		
        		try {
    	        	MidletDeployment midlet = null;
    				if(mtjProject != null){
    					midlet = (MidletDeployment)mtjProject.getDeployment();		        	
    			        lblSelectedProject.setText(mtjProject.getProject().getName());
    				}else{
    					lblSelectedProject.setText(((IJavaProject)selectedResource).getPath().toString());
    				}
    				if(midlet != null){
    					txtResourceFile.setText(midlet.getJad().getName());
    					btnDeploy.setEnabled(true);
    				}else{
    					txtResourceFile.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy);
    		        	txtResourceFile.selectAll();
    		        	btnDeploy.setEnabled(false);
    				}
    			} catch (CoreException e) {
    				// TODO Auto-generated catch block
    				e.printStackTrace();
    			}
        	}
        	lblSelectedProject.setText(container.getFullPath().toString());
        	txtResourceFile.setText(resource.getFullPath().toString());
		}else{
			lblSelectedProject.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_NoProject);
        	txtResourceFile.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectResourceToDeploy);	
           	txtResourceFile.selectAll();
		}
	}

	private void addRbtnFiltersListeners(Button rbtnConnectedDevices, Button rbtnAlsoDisconnectedDevices, Button rbtnPrjDevices, Button rbtnAllDevices) {
        // TODO Auto-generated method stub
        rbtnConnectedDevices.addSelectionListener(new SelectionListener(){
        	
			public void widgetSelected(SelectionEvent e) {
                // TODO Auto-generated method stub
                contentProvider.setFilters(0, DialogConstants.CONNECTED_DEVICES, 0);
                deviceViewer.refresh(); 
            }

			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
           
        });
        
        rbtnAlsoDisconnectedDevices.addSelectionListener(new SelectionListener(){
        	
			public void widgetSelected(SelectionEvent e) {
                // TODO Auto-generated method stub
                contentProvider.setFilters(0, DialogConstants.ALL_DEVICES_STATUS, 0);
                deviceViewer.refresh();
            }

			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
            
        });
        
        rbtnPrjDevices.addSelectionListener(new SelectionListener(){
        	
			public void widgetSelected(SelectionEvent e) {
                // TODO Auto-generated method stub
                contentProvider.setFilters(DialogConstants.COMPATIBLE_DEVICES, 0, 0);
                deviceViewer.refresh();
            }

			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}

        });
        
        rbtnAllDevices.addSelectionListener(new SelectionListener(){
        	
			public void widgetSelected(SelectionEvent e) {
                // TODO Auto-generated method stub
                contentProvider.setFilters(DialogConstants.ALL_DEVICES, 0, 0);
                deviceViewer.refresh();       
            }

			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}

        });
    }


    
    
    private void addBtnDeployListeners(Button btnDeploy) {
    	
		btnDeploy.addSelectionListener(new SelectionListener(){

			public void widgetSelected(SelectionEvent e) {
				//ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
				//monitor = progressMonitorDialog.getProgressMonitor();
				//progressMonitorDialog.open();
				if(selectedResource instanceof IJavaProject){
					if(selectedResource != null){
				        IJavaProject javaProject = ((IJavaProject)selectedResource);
				        try {
				        	Deployment deployment = null;
							IMtjProject mtjProject = MtjProject.getMtjProject(javaProject);
							if(mtjProject != null){
								deployment = mtjProject.getDeployment();		
							}else{
								// TODO implement resource deployment
								dplmDialog.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_SelectedProjectNotMTJ, true);
								return;
								//
								//deployment = new ResourceDeployment();
							}
							
							MtjExtension[] list = MtjServices.getInstance().getImplementations( ExtensionType.DEPLOYMENT_PROVIDER_LITERAL, null, null, true);	              
		                    DeploymentProvider dplp = (DeploymentProvider) list[0];
		                    
		                    // TODO testing	                    
		                    //Device[] devices = dplp.getDevices();
		                    //
		                   Object[] checkedElements = deviceViewer.getCheckedElements();
		                   selectedDevices.clear();
		                   for(int i=0; i<checkedElements.length; i++){
		                	   Object current = checkedElements[i];
		                	   if(current instanceof Device){
		                		   selectedDevices.add((Device)current);		                
		                	   }
		                   }
		                   Device[] toDeploy = new Device[selectedDevices.size()];
		                   Object[] objectDevices = selectedDevices.toArray();
		                   for(int i=0; i<selectedDevices.size(); i++){
		                	   toDeploy[i] = (Device)objectDevices[i];
		                   }
		                    dplp.deploy(deployment, toDeploy, null, monitor);
						} catch (MtjException ex) {
							// TODO Auto-generated catch block
							ex.printStackTrace();
						} catch (CoreException cex) {
							// TODO Auto-generated catch block
							cex.printStackTrace();
						}
					}else{
						dplmDialog.updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_NoResourceSelected, true);
					}
				}else if(selectedResource instanceof IResource){
					IResource resource = (IResource) selectedResource;
					//TODO to change the implementation later on
					if(!resource.getFileExtension().equalsIgnoreCase("jad")){ //$NON-NLS-1$
						updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_OnlyMidlets, true);					
					}else{
						
					}
				}
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
			
		});        
    }

    private void addBtnRefreshListeners(Button btnRefresh) {
        btnRefresh.addSelectionListener(new SelectionListener(){

			public void widgetSelected(SelectionEvent e) {
                // TODO Auto-generated method stub
				deviceViewer.refresh();
            }
			
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
            
        });     
        
    }

    private void addBtnPropertiesListeners(Button btnProperties) {
           btnProperties.addSelectionListener(new SelectionListener(){

   			public void widgetSelected(SelectionEvent e) {
                    // TODO Auto-generated method stub
                ISelection selected = deviceViewer.getSelection();
                if(deviceViewer.getSelection().isEmpty()) {
                    updateStatus(DeploymentManagementUIMessages.DeploymentManagementDialog_NoDeviceOrProviderSelected, true);
                    return;
                }/*
                if(event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    for (Iterator iterator = selection.iterator(); iterator.hasNext();) {
                        Object domain = (Model) iterator.next();
                        String value = labelProvider.getText(domain);
                        toShow.append(value);
                        toShow.append(", ");
                    }
                    // remove the trailing comma space pair
                    if(toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    text.setText(toShow.toString());
                }*/                    
                }

			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
                
            });        
    }

    private void addDeviceViewerListeners(final CheckboxTreeViewer deviceViewer) {
        deviceViewer.addSelectionChangedListener(new ISelectionChangedListener() {

            public void selectionChanged(SelectionChangedEvent event) {
                // TODO Auto-generated method stub
                if(event.getSelection().isEmpty()) {
                    lblDescription.setText(""); //$NON-NLS-1$
                    return;
                }
                if(event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    for (Iterator iterator = selection.iterator(); iterator.hasNext();) {
                        Object domain = iterator.next();
                        String value = labelProvider.getDescription(domain);
                        toShow.append(value);
                        toShow.append(", "); //$NON-NLS-1$
                    }
                    // remove the trailing comma space pair
                    if(toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    lblDescription.setText(toShow.toString());
                }

            }
            
        });

        deviceViewer.addCheckStateListener(new ICheckStateListener() {
            public void checkStateChanged(CheckStateChangedEvent event) {
            	Object selection = event.getElement();
            	if(selection instanceof DeploymentProvider){
            		if(event.getChecked()){
            			deviceViewer.expandToLevel(1);
            			deviceViewer.setSubtreeChecked(selection, true);            			
            		}else{
            			deviceViewer.setSubtreeChecked(selection, false);
            		}
            	}else if(selection instanceof Device){
            		Device checkedDevice = (Device)selection;
            		if(event.getChecked()){
            			deviceViewer.setChecked(selection, true);
            			//deviceViewer.setGrayChecked(contentProvider.getParent(selection), true);
            			selectedDevices.add(checkedDevice);
            		}else{
            			deviceViewer.setParentsGrayed(selection, false);
            			selectedDevices.remove(checkedDevice);
            		}
            	}

            }

        });
        deviceViewer.addTreeListener(new ITreeViewerListener() {
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                //updateTree();
            }
        });     
    }

    private void addProtocolSelectionListener(Combo cboProtocol) {
        cboProtocol.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
  
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                // TODO Auto-generated method stub
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.HELP_ID,
				IDialogConstants.HELP_LABEL, false);
		btnClose = createButton(parent, IDialogConstants.CLOSE_ID,
				IDialogConstants.CLOSE_LABEL, false);
		btnClose.addSelectionListener(new SelectionListener(){

			public void widgetSelected(SelectionEvent e) {
				dplmDialog.close();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
			
		});
	}

	public boolean close() {
		return super.close();
	}

	protected void buttonPressed(int buttonId) {
		super.buttonPressed(buttonId);
	}

	/**
	 * Updates error messages in the banner area
	 */
	private void updateStatus(String message, boolean error) {
		if(error){
			setErrorMessage(message);
		}else{
			setErrorMessage(null);
			setMessage(message);
		}
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(DeploymentManagementUIMessages.DeploymentManagementDialog_DeployResource); 
		newShell.setImage(DeploymentManagementUIPlugin.getImageDescriptor("/icons/deploy.gif").createImage()); //$NON-NLS-1$
	}
	
	protected Object getSelectedResource(){
		Object res = null;
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        
        if (selection != null){
        	if (selection instanceof IStructuredSelection){
        		IStructuredSelection structuredSelection = (IStructuredSelection) selection;
        
        		if (structuredSelection != null){
        			res = structuredSelection.getFirstElement();
        		}
        	}
        }
        return res;
	}
	
	protected void cancelPressed() {
		close();
	}
 
}
