/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.properties;

import java.util.logging.Logger;

import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.mtj.extension.dplm.ui.preferences.DeployComposite;
import org.eclipse.mtj.extension.dplm.ui.preferences.DeployController;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PropertyPage;

public class DeployPage extends PropertyPage implements IWorkbenchPreferencePage {
	private static Logger log = Logger.getLogger(DeployPage.class.getName());

	private DeployController controller;
	
	public DeployPage() {
		super();
		log.info(DeploymentManagementUIMessages.DeployPage_ConstructingDeployPropertiesPage);
		setTitle(DeploymentManagementUIMessages.PropertiesDeployPage_Deploy);
		// setDescription("Create and modify Device Platforms");
		noDefaultAndApplyButton();
	}

	protected Control createContents(Composite parent) {
		DeployComposite composite = new DeployComposite(parent);
		controller = new DeployController(composite);
		return composite;
	}

	public void init(IWorkbench workbench) {
	}

	public boolean performOk() {
		return true;
	}	
}
