/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

/**
 * Build Provider is responsible to the build the project from source to deployment.
 * Build Provider instances can implement the build process differently. 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:19 $
 * <br>
 */
public interface BuildProvider extends MtjExtension {

	/**
	 * Method getSupportedTypes that returns the build types that are supported by the Build Provider. 
	 * 
 	 * @return
	 */
	public BuildType[] getSupportedTypes() throws MtjException;

	/**
	 * @param project
	 * @param type
	 * @param targetPlatform
	 * @param monitor
	 * @return
	 */
	public Deployment build(IMtjProject project, String projectNatureId, BuildType type,
			RuntimePlatformDefinition targetPlatform,
			IProgressMonitor monitor) throws MtjException;
}
