/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.ActionType;
import org.eclipse.mtj.api.preprocessing.Condition;
import org.eclipse.mtj.exception.MtjException;


/**
 * Preprocessing is used to solve device fragmentation problem in source code level.
 * Preprocessing Provider implements functionality that is used to modify source code to match target devices.
 * 
 * </p>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:50:20 $
 * <br>
 */
public interface ProprocessingProvider extends BuildExtension {

	/**
	 * Method process switches the code blocks on, that follows the given processing conditions, 
	 * and switches off other ones.
	 * 
	 * @param sourceFolder
	 * @param targetFolder
	 * @param conditions
	 * @param monitor
	 */
	public void process(IFolder sourceFolder, IFolder targetFolder,
			Condition[] conditions, IProgressMonitor monitor) throws MtjException;

	/**
	 * Method is used to get code template for a given processing condition. 
	 * 
	 * @param actionType
	 * @param condition
	 * @return
	 */
	public String getCodeTemplate(ActionType actionType, Condition condition) throws MtjException;

}
