/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 

package org.eclipse.mtj.api.model;

import java.io.File;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;

/**
 * Instances of this interface implement Emulators that are run as executables
 * rather than as a Java class. Executable emulators must be capable of
 * providing the qualified path to the executable to be run for emulation.
 */

public interface IExecutablePlatform {

	/**
	 * Get the executable to be run to execute the emulator functionality.
	 * 
	 * @return a File reference to the executable to be used for emulation.
	 * @throws CoreException
	 */
	public File getExecutable() throws CoreException;

	/**
	 * Return the arguments to be sent to the emulator.
	 * 
	 * @param configuration
	 *            the launch configuration in which launch information has been
	 *            specified
	 * @return the arguments for starting the emulator
	 * @throws CoreException
	 *             when an error occurs accessing the launch configuration
	 */
	public String getArguments(ILaunchConfiguration configuration, Deployment deployment, 
			boolean debugMode, int debugPort, String natureId, Device device) throws CoreException;
}
