/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.rpm;

import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class RpmPlugin extends Plugin {
	private static final String LOGGING_LEVEL = "logging.level"; //$NON-NLS-1$

	static {
		Logger l = Logger.getLogger(""/*RpmPlugin.class.getName()*/); //$NON-NLS-1$
		Properties p = new Properties();
		try {
			p.load(RpmPlugin.class.getClassLoader().getResourceAsStream("org/eclipse/mtj/extension/rpm/rpm.properties")); //$NON-NLS-1$
		} catch (Exception e) {
			l.log(Level.WARNING,Messages.RpmPlugin_CouldNotLoadRpmProperties,e);
		}
		String levelString = System.getProperty("logging.level",p.getProperty(LOGGING_LEVEL, "WARNING")); //$NON-NLS-1$ //$NON-NLS-2$
		Level level = Level.parse(levelString);
		l.setLevel(level);			
		Handler[] h = l.getHandlers();
		for (int i = 0; i < h.length; i++) {
			l.removeHandler(h[i]);
		}	
		
		Handler ch = new ConsoleHandler();
		ch.setLevel(level);	
		l.addHandler(ch);	

		l.info(Messages.RpmPlugin_Init);
	}

	private static final Logger log = Logger.getLogger(RpmPlugin.class.getName());	
	
	//The shared instance.
	private static RpmPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public RpmPlugin() {
		log.info(Messages.RpmPlugin_ConstructingPlugin);
		plugin = this;
	}

	public static String getPluginId ()
	{
		return getDefault().getBundle().getSymbolicName();
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static RpmPlugin getDefault() {
		return plugin;
	}

}
