/**
 * Copyright (c) 2003-2006 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.core.library.config;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.mtj.core.version.Version;

/**
 * Tracks a specification of a particular library.  Includes
 * the name of the specification, an identifier and the 
 * version of that specification.
 * <p />
 * Copyright (c) 2003-2006 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.2 $
 * <br>
 * $Date: 2006/09/20 09:01:19 $
 * <br>
 * @author Craig Setera
 */
public class LibrarySpecification {	
	private String identifier;
	private String type;
	private String name;
	private String label;
	private Version version;
	private String classEntry;
	private String binFile;
	private String sourceFile;
	private String javadocFile;
	private String fileNameList;
	
	private Map<String,String> packageMap = new HashMap();
	private String packages;
	
	public String getPackageFiles(String packageString) {
		return packageMap.get(packageString);
	}
	
	public void setPackage(String packageString, String fileListString) {
		packageMap.put(packageString, fileListString);
	}
	
	public String getPackages() {
		return packages;
	}
	
	public void setPackages(String packages) {
		this.packages = packages;
	}
		
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return Returns the version.
	 */
	public Version getVersion() {
		return version;
	}
	
	/**
	 * @param version The version to set.
	 */
	public void setVersion(Version version) {
		this.version = version;
	}

	/**
	 * @return Returns the identifier.
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * @param identifier The identifier to set.
	 */
	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	/**
	 * @return Returns the binFile.
	 */
	public String getBinFile() {
		return binFile;
	}

	/**
	 * @param binFile The binFile to set.
	 */
	public void setBinFile(String binFile) {
		this.binFile = binFile;
	}

	/**
	 * @return Returns the fileNameList.
	 */
	public String getFileNameList() {
		return fileNameList;
	}

	/**
	 * @param fileNameList The fileNameList to set.
	 */
	public void setFileNameList(String fileNameList) {
		this.fileNameList = fileNameList;
	}

	/**
	 * @return Returns the javadocFile.
	 */
	public String getJavadocFile() {
		return javadocFile;
	}

	/**
	 * @param javadocFile The javadocFile to set.
	 */
	public void setJavadocFile(String javadocFile) {
		this.javadocFile = javadocFile;
	}

	/**
	 * @return Returns the label.
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * @param label The label to set.
	 */
	public void setLabel(String label) {
		this.label = label;
	}

	/**
	 * @return Returns the sourceFile.
	 */
	public String getSourceFile() {
		return sourceFile;
	}

	/**
	 * @param sourceFile The sourceFile to set.
	 */
	public void setSourceFile(String sourceFile) {
		this.sourceFile = sourceFile;
	}

	/**
	 * @return Returns the type.
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type The type to set.
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return Returns the classEntry.
	 */
	public String getClassEntry() {
		return classEntry;
	}

	/**
	 * @param classEntry The classEntry to set.
	 */
	public void setClassEntry(String classEntry) {
		this.classEntry = classEntry;
	}
}
