package org.eclipse.mtj.jad.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 2000, 2003 All Rights Reserved
 */

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class MidletSearchEngine {

	/**
	 * Returns all non-abstract MIDlets.
	 *
	 * @return the list of all ITypes for non-abstract classes deriving from 
	 * javax.microedition.midlet.MIDlet
	 * 
	 */
	public static List searchSubtypes(IResource scope, IProgressMonitor monitor) throws JavaModelException, CoreException {
		List typesFound= new ArrayList();
		
		// Find and return all non-abstract classes that inherit from MIDlet.
		
		// First find the IJavaProject associated with this scope
		IProject project = scope.getProject();
		IJavaProject javaProject = (IJavaProject)project.getNature(JavaCore.NATURE_ID);

		// Build a type hierarchy rooted at the MIDlet class
		IType midletType = javaProject.findType("javax.microedition.midlet.MIDlet"); //$NON-NLS-1$
		if (midletType != null) { // if the user no longer has the MIDP library in the classpath then this will be null and the dialog will die a horrible, horrible death and hang the UI.
			ITypeHierarchy hierarchy = midletType.newTypeHierarchy(javaProject, monitor);
			
			// Collect all types derived from MIDlet
			IType[] types = hierarchy.getAllSubtypes(midletType);
			
			// Add all non-abstract types to the result list
			for (int idx = 0; idx < types.length; idx++)
			{
				IType thisType = types[idx];
				
				if (!Flags.isAbstract(thisType.getFlags()))
				{
					typesFound.add(thisType);
				}
			}
		}
				
		return typesFound;
	}

}

