/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dpp.nokia;

import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.core.toolkit.DevicePlatformImporter;
import org.eclipse.mtj.extension.dpp.uei.AbstractUeiDevicePlatformProvider;

/** Nokia specific extension to Generic UEI device platform importer.*/
public class NokiaSdk extends AbstractUeiDevicePlatformProvider  {
	
	private static NokiaSdk instance;
	
	public static NokiaSdk getDefault() {
		return instance;
	}
	
	public NokiaSdk(){
		
		super();
		
		instance = this;
		
		setId(NokiaPlugin.getDefault().getBundle().getSymbolicName());
		setDescription("Nokia Sdk Device Platform Provider");
		setVendor("Nokia");
		setVersion("1.0.0");
		setType(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.core.toolkit.ToolkitSupport#getDevicePlatformImporter()
	 */
	public DevicePlatformImporter getDevicePlatformImporter() {

		return NokiaSdkDevicePlatformImporter.getDefault();
	}

	/**
	 * Method returns Plugin name that owns the DevicePlatform data.
	 * 
	 * @return
	 */
	public String getPluginName() {
		return NokiaPlugin.getDefault().getBundle().getSymbolicName();
	}

}
