/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dm.ui.preferences;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.mtj.extension.dm.ui.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;

public class DeviceInfoComposite extends Composite {
	private Label rpName;
	private Label deviceName;
	private Tree apiTree; 
	private Group profileGroup;
	private Group configGroup;

	public Tree getApiTree() {
		return apiTree;
	}
	
	public Label getDeviceNameLabel() {
		return rpName;
	}

	public Label getDeviceDescriptionLabel() {
		return deviceName;
	}
	
	public Group getProfileGroup() {
		return profileGroup;
	}

	public Group getConfigGroup() {
		return configGroup;
	}
	
	public DeviceInfoComposite(Composite parent) {
		super(parent, SWT.NONE);		
		setLayout(new GridLayout());
		setLayoutData(new GridData(GridData.FILL_BOTH));
		getComposite(this);
	}
	
	public Composite getComposite(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Group infoGroup = createGroup(composite, false);
		infoGroup.setText(Messages.DeviceInfoComposite_Device);
		
		createLabel(infoGroup, Messages.DeviceInfoComposite_NameLabel);
		rpName = createLabel(infoGroup, ""); //$NON-NLS-1$
		createLabel(infoGroup, Messages.DeviceInfoComposite_DeviceLabel);
		deviceName = createLabel(infoGroup, ""); //$NON-NLS-1$
		
		profileGroup = createGroup(composite, 4, false);
		profileGroup.setText(Messages.DeviceInfoComposite_Profiles);
		configGroup = createGroup(composite, 4, false);
		configGroup.setText(Messages.DeviceInfoComposite_Configurations);

		// apiGroup
		Group apiGroup = new Group(composite, SWT.FILL);
		GridLayout layout = new GridLayout();
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.numColumns = 1;
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.heightHint = 200;
		gridData.widthHint = 400;
		apiGroup.setLayout(layout);
		apiGroup.setLayoutData(gridData);
		apiGroup.setText(Messages.DeviceInfoComposite_ServiceApis);

		apiTree = createApiTree(apiGroup);
		
		return composite;
	}
	
	public static Tree createApiTree(Group apiGroup) {
		Tree tree = new Tree(apiGroup, SWT.BORDER | SWT.FULL_SELECTION | SWT.V_SCROLL | SWT.H_SCROLL);
		
		GridLayout layout = new GridLayout(1, false);
		tree.setLayout(layout);

		GridData data = new GridData(SWT.FILL, SWT.FILL, true, true);
		tree.setLayoutData(data);
		return tree;
	}

	public static Group createGroup(Composite parent, boolean verticalSpace) {
		return createGroup(parent, 2, verticalSpace);
	}
	
	public static Group createGroup(Composite parent, int columnCount, boolean verticalSpace) {
		Group group = new Group(parent, SWT.FILL);
		GridLayout layout = new GridLayout(columnCount, false);
		group.setLayout(layout);

		GridData data = new GridData(SWT.FILL, SWT.FILL, true, verticalSpace);
		group.setLayoutData(data);

		return group;
	}

	public static Label createLabel(Composite parent, String text){	
		Label label = new Label(parent, SWT.NONE);
		label.setText(text);
		label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING));
		
		return label;
	}
		
	protected String[] variableTargetDeviceTableColumnHeaders = {
			Messages.DeviceInfoComposite_Import, Messages.DeviceInfoComposite_DeviceName, Messages.DeviceInfoComposite_DevicePlatformName 
	};
	
	protected ColumnLayoutData[] variableTargetDeviceTableColumnLayouts = {
			new ColumnWeightData(20), new ColumnWeightData(50), new ColumnWeightData(50)
	};	
}


