/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.preferences;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.widgets.Composite;

/** Directory field editor for selecting Device Platform Root location */
public class DevicePlatformDirectoryEditor extends DirectoryFieldEditor {

	
	private boolean rootValid;
	
	private String infoMessage; //Information about problem if any
	private String nonValidRoot; //Root location contents could not be validated
	private String nonValidPath; //Path was not valid

	public DevicePlatformDirectoryEditor(String name, String label, Composite parent) {

		super(name, label, parent);
		setValidateStrategy(VALIDATE_ON_KEY_STROKE);
	}

	public boolean isValid() {

		return rootValid;
	}

	protected void refreshValidState() {

		// TODO implement this
		String rootDir = getStringValue();

		if (rootDir == null || rootDir.trim() == "") { //$NON-NLS-1$
//			getButton(IDialogConstants.OK_ID).setEnabled(false);
//			setMessage(rootMessage, IMessageProvider.INFORMATION);
			rootValid = false;
			infoMessage = null;
		} else {
			IPath path = new Path(rootDir);
			//TODO implement Runtime Platform validation
			if (path.isValidPath(rootDir)) {
//				getButton(IDialogConstants.OK_ID).setEnabled(true);
//				setMessage(null); //clear message
				
				//TODO chech for platform validity
				if(true){
					rootValid = true;
					infoMessage = null;
				}
				else{
					rootValid = false;
					infoMessage = nonValidRoot;
				}
			}
			else{
				rootValid = false;
				infoMessage = nonValidPath;
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.StringFieldEditor#getErrorMessage()
	 */
	@Override
	public String getErrorMessage() {
		
		if(infoMessage != null){
			return infoMessage;
		}
		else{
			return super.getErrorMessage();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.DirectoryFieldEditor#doCheckState()
	 */
	@Override
	protected boolean doCheckState() {
		// TODO Auto-generated method stub
		return super.doCheckState();
	}
	
	
}
