/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.preferences;

import java.util.List;
import java.util.Set;
import java.util.Vector;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.devices.DevicesPackage;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.extension.dm.ui.Messages;

public class DevicePlatformListContentProvider implements ITreeContentProvider {
	
	private EList myContents;
	private Viewer myViewer;
	
	public DevicePlatformListContentProvider(Viewer viewer){
		
		myViewer = viewer;
	}

	public Object[] getChildren(Object parentElement) {
		
		List l = new Vector();
		
		if(parentElement instanceof DevicePlatform){
			DevicePlatform dp = (DevicePlatform)parentElement;
			l.addAll(dp.getDevices());
			l.addAll(dp.getRuntimePlatformDefinitions());
			return l.toArray();
		}
		else if(parentElement instanceof RuntimePlatformDefinition){
			RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)parentElement;
			l.addAll(rpd.getDeviceConfigurations());
			l.addAll(rpd.getDeviceProfiles());
			l.addAll(rpd.getServiceApis());
			return l.toArray();
		}
		else if(parentElement instanceof Device){
			Device device = (Device)parentElement;
			EList rpds = device.getRuntimePlatformDefinitions();
			if(rpds != null){
				l.addAll(device.getRuntimePlatformDefinitions());
				return l.toArray();
			}
			return null;
		}
		else if(parentElement instanceof DeviceConfiguration){
			DeviceConfiguration config = (DeviceConfiguration)parentElement;
			l.add(config.getImplementation());
			return l.toArray();
		}
		else if(parentElement instanceof DeviceProfile){
			DeviceProfile profile = (DeviceProfile) parentElement;
			l.addAll(profile.getServiceApis());
			return l.toArray();
		}
		else if(parentElement instanceof ServiceApi){
			ServiceApi sapi = (ServiceApi) parentElement;
			l.add(sapi.getDescription());
			l.add(sapi.getImplementation());
			return l.toArray();
		}
		else if(parentElement instanceof ImplementationRef){
			ImplementationRef ref = (ImplementationRef)parentElement;
			//l.add(ref.getFileRef()); //already in parent
			l.add(ref.getSourceRef());
			l.add(ref.getJavadocRef());
			return l.toArray();
		}
		else
			return null;
	}

	public Object getParent(Object element) {

		if(element instanceof Device){
			//TODO fetch DevicePlatform from DeviceManagement
		}
		return null;
	}

	public boolean hasChildren(Object element) {
		
		if(element instanceof DevicePlatform)
			return true;
		else if(element instanceof RuntimePlatformDefinition)
			return true;
		else if(element instanceof Device)
			return true;
		else if(element instanceof DeviceProfile)
			return true;
		else if(element instanceof DeviceConfiguration)
			return true;
		else if(element instanceof ServiceApi)
			return true;
		else if(element instanceof ImplementationRef){
			
			ImplementationRef ref = (ImplementationRef) element;
			String javadoc = ref.getJavadocRef();
			String source = ref.getSourceRef();
			if(javadoc != null && source != null){
				//check that either one has some content
				if(javadoc.length() > 1 || source.length() > 1){
					return true;
				}
				else{
					return false;
				}
			}
			else{
				return false;
			}
		}
		else
			return false;
	}

	public Object[] getElements(Object inputElement) {
		
		if(inputElement instanceof EList){
			EList eList = (EList)inputElement;
			return eList.toArray();
		}
		
		return ((Set)inputElement).toArray();
	}

	public void dispose() {
		// TODO Auto-generated method stub
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		
		myViewer = viewer;

		if(newInput instanceof EList){
			myContents = (EList)newInput;
		}
	}

	public void addVariable(Object inputElement, RuntimePlatformDefinition newRpd) {
		
		EList eList = null;
		
		// Create list if no input
		if (inputElement == null) {

			inputElement = new EObjectContainmentEList(
					RuntimePlatformDefinition.class,
					(InternalEObject) newRpd,
					DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS);
			
			((EList)inputElement).add(newRpd);
		}
		else{
			if(inputElement instanceof EList){
				eList = (EList)inputElement;
				
				if(eList.size() == 0 || eList.get(0) instanceof RuntimePlatformDefinition){
//					((EList)inputElement).add(newRpd);
					((EList)inputElement).add(newRpd);
				}
			}
		}
		
		myViewer.setInput(inputElement);
		
	}
	
	public EList removeVariable(Object oldInputElement, DevicePlatform selectedDp) throws Exception{
		
		if(oldInputElement instanceof DevicePlatform){

			DevicePlatform[] oldInput = (DevicePlatform[])oldInputElement;
			if(oldInput.length == 1){
				return null;
			}
			
			EList list = new BasicEList();
			for(int i = 0; i < oldInput.length; i++){
				if(!oldInput[i].equals(selectedDp)){
					list.add(oldInput[i]);
				}
			}
			
			return list;
		}
		else if(oldInputElement instanceof EList){
			
			EList list = (EList)oldInputElement;
			
			if(list.size() == 1){
				return null;
			}
			
			list.remove(selectedDp);
			return list;
		}
		
		throw new Exception(Messages.DevicePlatformListContentProvider_UnknownContentType);
	}
	
}
