/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.test;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.mtj.api.devices.Configuration;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.devices.DevicesPackage;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;

public class TestDevicePlatformImpl extends EObjectImpl implements DevicePlatform {
	
	private PlatformType myType;
	private boolean myDebugEnablement;
	private boolean myPreferenceExistence;
	private boolean myUtilitiesExistence;
	private EList myDevices;
	private RuntimePlatformDefinition[] myRpds;
	
	public static final String copyright = ""; //$NON-NLS-1$

	/**
	 * The cached value of the '{@link #getProtectionDomains() <em>Protection Domains</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProtectionDomains()
	 * @generated
	 * @ordered
	 */
	protected EList protectionDomains = null;

	/**
	 * The cached value of the '{@link #getConfiguration() <em>Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfiguration()
	 * @generated
	 * @ordered
	 */
	protected Configuration configuration = null;

	/**
	 * The default value of the '{@link #getCommunicationProtocol() <em>Communication Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommunicationProtocol()
	 * @generated
	 * @ordered
	 */
	protected static final DeviceCommunicationProtocol COMMUNICATION_PROTOCOL_EDEFAULT = DeviceCommunicationProtocol.PROTOCOL_UEI_LITERAL;

	/**
	 * The cached value of the '{@link #getCommunicationProtocol() <em>Communication Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommunicationProtocol()
	 * @generated
	 * @ordered
	 */
	protected DeviceCommunicationProtocol communicationProtocol = COMMUNICATION_PROTOCOL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDeviceDescription() <em>Device Description</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceDescription()
	 * @generated
	 * @ordered
	 */
	protected DeviceDescription deviceDescription = null;

	/**
	 * The cached value of the '{@link #getRuntimePlatformDefinitions() <em>Runtime Platform Definitions</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimePlatformDefinitions()
	 * @generated
	 * @ordered
	 */
	protected EList runtimePlatformDefinitions = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #getVendor() <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVendor()
	 * @generated
	 * @ordered
	 */
	protected static final String VENDOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVendor() <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVendor()
	 * @generated
	 * @ordered
	 */
	protected String vendor = VENDOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getDevices()
	 */
	public EList getDevices() {
		
		return myDevices;
	}
	
	public void setDevices(Device[] devices){
		
		myDevices = new EObjectContainmentEList(Device.class, this, DevicesPackage.DEVICE_PLATFORM__DEVICES);
		for(int i = 0; i < devices.length; i++){
			myDevices.add(devices[i]);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getType()
	 */
	public PlatformType getType() {

		return myType;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#setType(org.eclipse.mtj.api.enumerations.PlatformType)
	 */
	public void setType(PlatformType value) {

		myType = value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getConfiguration()
	 */
	public Configuration getConfiguration() {

		return configuration;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#setConfiguration(org.eclipse.mtj.api.devices.Configuration)
	 */
	public void setConfiguration(Configuration value) {
			
		configuration = value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getRuntimePlatformDefinitions()
	 */
	public EList getRuntimePlatformDefinitions() {

		return runtimePlatformDefinitions;
	}
	
	public void setRuntimePlatformDefinitions(RuntimePlatformDefinition[] rpds){
			
			myRpds = rpds;
			if (runtimePlatformDefinitions == null) {
				runtimePlatformDefinitions = new EObjectContainmentEList(RuntimePlatformDefinition.class, this, DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS);
			}
			for(int i = 0; i < myRpds.length; i++){
				runtimePlatformDefinitions.add(myRpds[i]);
			}
		}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getName()
	 */
	public String getName() {

		return name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#setName(java.lang.String)
	 */
	public void setName(String value) {

		name = value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getVendor()
	 */
	public String getVendor() {

		return vendor;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#setVendor(java.lang.String)
	 */
	public void setVendor(String value) {
		
		vendor = value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#getVersion()
	 */
	public String getVersion() {

		return version;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#setVersion(java.lang.String)
	 */
	public void setVersion(String value) {
		
		version = value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isDebugEnabled()
	 */
	public boolean isDebugEnabled() {
		
		return myDebugEnablement;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#setDebugEnabled(boolean)
	 */
	public void setDebugEnabled(boolean value) {

		myDebugEnablement = value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isPreferencesDialogAvailable()
	 */
	public boolean isPreferencesDialogAvailable() {

		return myPreferenceExistence;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#setPreferencesDialogAvailable(boolean)
	 */
	public void setPreferencesDialogAvailable(boolean value) {
		
		myPreferenceExistence = value;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#isUtilitesDialogAvailable()
	 */
	public boolean isUtilitesDialogAvailable() {

		return myUtilitiesExistence;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.api.devices.DevicePlatform#setUtilitesDialogAvailable(boolean)
	 */
	public void setUtilitesDialogAvailable(boolean value) {

		myUtilitiesExistence = value;
	}

	public boolean isPredeploymentRequired() {
		// TODO Auto-generated method stub
		return false;
	}

	public void setPredeploymentRequired(boolean value) {
		// TODO Auto-generated method stub
		
	}

	public MtjExtension getDevicePlatformProvider() {
		// TODO Auto-generated method stub
		return null;
	}

	public void setDevicePlatformProvider(MtjExtension value) {
		// TODO Auto-generated method stub
		
	}
	
	public boolean isKeepAlivePortRequired() {
		return false;
	}

	public void setKeepAlivePortRequired(boolean val) {
	}

	public boolean isExecutableTargetRequired() {
		return false;
	}
	
	public void setExecutableTargetRequired(boolean val) {
	}

}
