/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.util;

import java.util.Set;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Configuration;
import org.eclipse.mtj.api.devices.ConfigurationItem;


public class DeviceConfigurationContentProvider implements ITreeContentProvider {

	public Object[] getChildren(Object parentElement) {
		
		if(parentElement instanceof ConfigurationItem){
			Object[] o = new String[1];
			o[0] = ((ConfigurationItem)parentElement).getDescription();
			return o;
		}
		return null;
	}

	public Object getParent(Object element) {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean hasChildren(Object element) {

		if(element instanceof ConfigurationItem){
			return true;
		}
		
		return false;
	}

	public Object[] getElements(Object inputElement) {
		
		if(inputElement instanceof Configuration){
			return ((EList)((Configuration)inputElement).getItems()).toArray();
		}

		return ((Set)inputElement).toArray();
	}

	public void dispose() {
		// TODO Auto-generated method stub
		
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// TODO Auto-generated method stub
		
	}

	

}
