/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.util;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mtj.api.devices.ConfigurationError;
import org.eclipse.mtj.api.devices.ConfigurationItem;
import org.eclipse.swt.graphics.Image;

public class DeviceConfigurationLabelProvider extends LabelProvider implements ILabelProvider {

	public Image getImage(Object element) {
		
		if(element instanceof ConfigurationError){
			
			//return error image
		}
		// TODO Auto-generated method stub
		return null;
	}

	public String getText(Object element) {
		
		StringBuffer sb = new StringBuffer();
		if(element instanceof ConfigurationItem){
			ConfigurationItem item = (ConfigurationItem)element; 
			sb.append(item.getLabel());
			sb.append(": "); //$NON-NLS-1$
			sb.append(item.getValue());
			sb.append(" ("); //$NON-NLS-1$
			sb.append(item.getDescription());
			sb.append(")"); //$NON-NLS-1$
		}
		else if(element instanceof ConfigurationError){
			ConfigurationError error = (ConfigurationError)element;
			sb.append(error.getErrorType());
			sb.append(": "); //$NON-NLS-1$
			sb.append(error.getDescription());
		}
		
		return sb.toString();
	}

	public void addListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
		
	}

	public void dispose() {
		// TODO Auto-generated method stub
		
	}

	public boolean isLabelProperty(Object element, String property) {
		// TODO Auto-generated method stub
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub
		
	}


}
