/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.rpm.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mtj.core.ui.preferences.PluginPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class RpmUiPlugin extends AbstractUIPlugin {

	//The shared instance.
	private static RpmUiPlugin plugin;
	
//	 A preference store wrapper around the core plugin plugin preferences
	private IPreferenceStore rpmPreferenceStore;
	
	/**
	 * The constructor.
	 */
	public RpmUiPlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static RpmUiPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.mtj.extension.rpm.ui.preferences", path); //$NON-NLS-1$
	}
	
	/**
	 * Return an IPreferenceStore wrapper around the EclipseME core
	 * plugin preferences.
	 * 
	 * @return
	 */
	public IPreferenceStore getPreferenceStore() {
		if (rpmPreferenceStore == null) {
			RpmUiPlugin plugin = RpmUiPlugin.getDefault();
			rpmPreferenceStore = 
				new PluginPreferenceStore(plugin, plugin.getPluginPreferences());
		}
		
		return rpmPreferenceStore;
	}
	
}
