/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.constants;

public interface CoreConstants {
	//----------test---------------------------------------------//
	public static final String P_PATH = "pathPreference"; //$NON-NLS-1$
	public static final String P_BOOLEAN = "booleanPreference"; //$NON-NLS-1$
	public static final String P_CHOICE = "choicePreference"; //$NON-NLS-1$
	public static final String P_STRING = "stringPreference"; //$NON-NLS-1$
	
	//------------------------------------------------------------//
	// The plugin ID
	public static final String PLUGIN_ID = "mtj.core"; //$NON-NLS-1$
	
	public static final boolean MTJ_PREF_DEPLOYMENT_ENABLE = false;
	public static final String MTJ_PREF_DEPLOYMENT_MODE = "false"; //$NON-NLS-1$
	
	// Directory preference keys and defaults
	public static final String MTJ_PREF_DEPLOYMENT_DIR = "deployment_dir"; //$NON-NLS-1$
	public static final String MTJ_PREF_VERIFIED_DIR = "verified_dir"; //$NON-NLS-1$
	
	public static final String MTJ_PREF_MODEL_DIR = "model_dir"; //$NON-NLS-1$
	
	// New project creation preferences
	public static final String MTJ_PREF_USE_RESOURCES_DIR = "use_resources_dir"; //$NON-NLS-1$
	public static final String MTJ_PREF_RESOURCES_DIR = "resources_dir"; //$NON-NLS-1$
	
	// Miscellaneous preferences
	public static final String MTJ_PREF_RMTDBG_DELAY = "rmt_debug_delay"; //$NON-NLS-1$
	public static final String MTJ_PREF_ANTENNA_JAR = "antenna_jar"; //$NON-NLS-1$
	
	// The superclass of all midlets
	public static final String MIDLET_SUPERCLASS = "javax.microedition.midlet.MIDlet"; //$NON-NLS-1$
	
	public static final String MTJ_NATURE_ID = PLUGIN_ID + ".nature"; //$NON-NLS-1$
	public static final String MTJ_PREVERIFIER_ID = PLUGIN_ID + ".preverifier"; //$NON-NLS-1$
	public static final String MTJ_PREPROCESSOR_ID = PLUGIN_ID + ".preprocessor"; //$NON-NLS-1$
	public static final String MTJ_TOOLKIT_TYPES_ID = "wirelessToolkitTypes"; //$NON-NLS-1$
	public static final String MTJ_CONFIGURATIONS_ID = "configurations"; //$NON-NLS-1$
	public static final String MTJ_PROFILES_ID = "profiles"; //$NON-NLS-1$
	
	//////////////////////////////////////////////////////////////////////
	// Error messages
	//////////////////////////////////////////////////////////////////////

	/** Error searching for jar executable */
	public static final int ERR_COULD_NOT_FIND_JAR_TOOL = 102;
	
}

