/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.errors;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;


public class MtjUIErrorResources {

	private static final String BUNDLE_NAME = "org.eclipse.mtj.core.ui.errors.MtjUIErrorsResources"; //$NON-NLS-1$
	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
	
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	
	public static String getString(String key)
	{
		String result = key;
		try
		{
			result = RESOURCE_BUNDLE.getString(key).trim();
		}
		catch(MissingResourceException e)
		{
		}
		
		return(result);
	}
	
	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.  Substitutions will be made if
	 * supplied.
	 * 
	 * @param key
	 * @param substitutions
	 * @return String
	 */
	
	public static String getString(String key, Object[] substitutions)
	{
		String result = '!' + key + '!';
		try
		{
			result = RESOURCE_BUNDLE.getString(key).trim();
		}
		catch(MissingResourceException e)
		{
		}
		
		return MessageFormat.format(result, substitutions);
	}


}
