/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.page;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

public class ExtensionNavigator extends Composite {

	TreeViewer treeViewer;
	ExtensionPropertyPage _parent;
	
	public ExtensionNavigator (Composite parent, int style, ExtensionPropertyPage _parent) {
		super (parent, style);
		this._parent = _parent;
		
		init();
	}

	protected void init() {
		this.setLayout(new GridLayout(1, true));
		GridData gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 1;
		this.setLayoutData(gd);
		
		treeViewer = new TreeViewer(getParent(), SWT.SINGLE);
		treeViewer.setLabelProvider(new TreeViewLabelProvider());
		treeViewer.setContentProvider(new TreeViewContentProvider());
		treeViewer.setInput(getInput());
		treeViewer.addSelectionChangedListener(new TreeViewSelectionChangedListener());
		
		gd = new GridData(GridData.BEGINNING);
		gd.horizontalSpan = 1;
		gd.widthHint = 200;
		gd.heightHint = 450;
		treeViewer.getTree().setLayoutData(gd);
		
	}
	
    public void changedExtensionActivity(boolean active) {
    	if ( treeViewer.getSelection() != null && treeViewer.getSelection() instanceof StructuredSelection ) {
    		Object o = ((StructuredSelection)treeViewer.getSelection()).getFirstElement();
    		if ( o instanceof ExtensionImplNode ) {
    			Object i = ((ExtensionImplNode)o).impl;
    			if ( i != null && i instanceof MtjExtension ) {
    				((MtjExtension)i).setActive(active);
    				treeViewer.refresh(o, true);
    			}
    		}
    	}
    }

	private Object getInput() {
		ArrayList arr = new ArrayList();
		
		Iterator it = ExtensionType.VALUES.iterator();
		while (it.hasNext()) {
			arr.add(new ExtensionNode(it.next().toString(),null));
		}
		
		return arr.toArray();
	}
	
	class TreeViewLabelProvider extends org.eclipse.jface.viewers.LabelProvider {

		public String getText(Object obj) {
			return obj.toString();
		}
		
		public Image getImage(Object obj) {
			return null;
		}
	}
	
	class TreeViewContentProvider implements ITreeContentProvider {
	    public Object[] getChildren(Object parentElement) {
	    	if ( parentElement instanceof ExtensionNode ) {
	    		ExtensionNode node = (ExtensionNode)parentElement;
	    		if (node.implementations == null) {
	    			ExtensionType e = ExtensionType.get(node.name);
	    			MtjExtension[] list = MtjServices.getInstance().getImplementations(e,null,null,false);
	    			if (list.length > 0) {
	    				ArrayList arr = new ArrayList();
	    				for (int i =0; i < list.length; i++) {
	    					MtjExtension m = list[i];
	    					ExtensionImplNode ein = new ExtensionImplNode(null, m);
	    					arr.add(ein);
	    				}
	    				return arr.toArray();
	    			}
	    			else {
	    				Object[] o = {};
	    				return o;
	    			}
	    		}
	    		return node.implementations;
	    	}
	    	if ( parentElement instanceof Object[] ) {
	    		return (Object[])parentElement;
	    	}
	    	return null;
	    }
	    public Object getParent(Object element) {
	    	if ( element instanceof ExtensionImplNode ) {
	    		return ((ExtensionImplNode)element).parent;
	    	}
	    	return null;
	    }
	    public boolean hasChildren(Object element) {
	    	if ( element instanceof ExtensionNode ) {
	    		return ((ExtensionNode)element).hasChildren();
	    	}
	    	if ( element instanceof ExtensionImplNode ) {
	    		return ((ExtensionImplNode)element).hasChildren();
	    	}
	    	return false;
	    }
	    public Object[] getElements(Object inputElement) {
	    	return getChildren(inputElement);
	    }
	    public void dispose() {
	    	
	    }
	    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	    	
	    }
	}

	class TreeViewSelectionChangedListener implements ISelectionChangedListener {
	    public void selectionChanged(SelectionChangedEvent event) {
	    	if ( event.getSelection() instanceof StructuredSelection && ((StructuredSelection)event.getSelection()).size() > 0) {
	    		Object f = ((StructuredSelection)event.getSelection()).getFirstElement();
	    		if ( f instanceof ExtensionImplNode ) {
		    		ExtensionImplNode s = (ExtensionImplNode)f;
		    		if (s.impl instanceof MtjExtension) {
		    			_parent.newSelection(s);
		    		}
	    		}
	    	}
	    }
	}
	
	class ExtensionNode {
		public String name;
		public ExtensionImplNode[] implementations;
		public ExtensionNode(String name, ExtensionImplNode[] implementations) {
			this.name = name;
			this.implementations = implementations;
		}
		public String toString() {
			return name;
		}
		public boolean hasChildren() {
			return true;
		}
	}
	
	class ExtensionImplNode {
		public String name;
		public Object impl;
		public Composite adminPage;
		public ExtensionNode parent;
		public ExtensionImplNode(String name, Object impl) {
			this.name = name;
			this.impl = impl;
		}
		public String toString() {
			if ( impl instanceof MtjExtension ) {
				MtjExtension m = (MtjExtension)impl;
				return (m.isActive() ? Messages.ExtensionNavigator_Active : Messages.ExtensionNavigator_NotActive) + m.getVendor() + Messages.ExtensionNavigator_0 + m.getVersion(); 
			}
			else {
				return name;
			}
		}
		public boolean hasChildren() {
			return false;
		}
	}
}
