/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.page;

import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.AdminGuiProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.page.ExtensionNavigator.ExtensionImplNode;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class ExtensionPropertyPage extends Composite {

    ExtensionNavigator en;
    ExtensionHeader eh;
    
    Group adminPageGroup;
    Composite adminPageComposite;
    Composite currentPage;

	public ExtensionPropertyPage (Composite parent, int style) {
		super (parent, style);
		
		init();
	}
	
   public void init() {
	    
		GridLayout layout = new GridLayout();
		setLayout(layout);
		layout.numColumns = 2;
		layout.marginHeight = 10;
		layout.marginWidth = 10;
		
		Group group1 = new Group(this, SWT.FILL);
		group1.setLayout(new GridLayout(1, true));
		GridData gd = new GridData(GridData.FILL_VERTICAL);
		gd.horizontalSpan = 1;
		gd.verticalSpan = 2;
		group1.setLayoutData(gd);
		group1.setText(Messages.ExtensionPropertyPage_Extensions);

        en = new ExtensionNavigator(group1, SWT.NONE, this);
        eh = new ExtensionHeader(this, SWT.NONE);
       
		adminPageGroup = new Group(this, SWT.FILL);
		adminPageGroup.setLayout(new GridLayout(1, true));
		gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 1;
		gd.verticalSpan = 1;
		adminPageGroup.setLayoutData(gd);
		adminPageGroup.setText(""); //$NON-NLS-1$
		adminPageGroup.setVisible(false);
		
		adminPageComposite = new Composite(adminPageGroup, SWT.FILL);
		adminPageComposite.setLayout(new RowLayout());
		
	}

    public void changedExtensionActivity(boolean active) {
    	en.changedExtensionActivity(active);
    }
    
    public void newSelection(ExtensionImplNode node) {
    	eh.setMtjExtension((MtjExtension)node.impl);
    	try {
	    	if (node.adminPage == null) {
	    		AdminGuiProvider agp = getAdminGuiProvider((MtjExtension)node.impl);
	    		if ( agp != null ) {
	    			node.adminPage = agp.create(adminPageComposite, SWT.NONE);
	    		}
	    	}
	    	if ( currentPage != null ) {
	    		currentPage.setVisible(false);
	    		currentPage = null;
	    	}
	    	if (node.adminPage != null) {
	    		adminPageGroup.setVisible(true);
	    		currentPage = node.adminPage;
	    		currentPage.setVisible(true);
	    		adminPageComposite.pack();
	    	}
	    	else {
	    		adminPageGroup.setVisible(false);
	    	}
    	}
    	catch (MtjException ex) {
    		// TODO: Show the error
    		ex.printStackTrace();
    	}
    }
    
    private AdminGuiProvider getAdminGuiProvider(MtjExtension extension) throws MtjException {
    	MtjExtension[] exts = 
    		MtjServices.getInstance().getImplementations(ExtensionType.ADMIN_GUI_PROVIDER_LITERAL,null,null,false);
    	for (int i = 0; i < exts.length; i++) {
    		AdminGuiProvider a = (AdminGuiProvider)exts[i];
    		if ( a.getOwner() == extension ) {
    			return a;
    		}
    	}
    	return null;
    }
}
