/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.constants.CoreConstants;
import org.eclipse.mtj.core.ui.Messages;

public class CoreUIPreferenceInitializer extends AbstractPreferenceInitializer 
				implements CoreConstants {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = MtjCoreUiPlugin.getDefault().getPreferenceStore();
		store.setDefault(CoreConstants.P_BOOLEAN, true);
		store.setDefault(CoreConstants.P_CHOICE, Messages.CoreUIPreferenceInitializer_Choice2);
		store.setDefault(CoreConstants.P_STRING, Messages.CoreUIPreferenceInitializer_DefaultValue);
		
		store.setDefault(CoreConstants.MTJ_PREF_DEPLOYMENT_MODE, false);
		store.setDefault(CoreConstants.MTJ_CONFIGURATIONS_ID, ""); //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_NATURE_ID, "");				 //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_PREPROCESSOR_ID, ""); //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_PREVERIFIER_ID, ""); //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_PROFILES_ID, ""); //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_TOOLKIT_TYPES_ID, ""); //$NON-NLS-1$
		store.setDefault(CoreConstants.MIDLET_SUPERCLASS, ""); //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_PREF_ANTENNA_JAR, "../lib/antenna.jar"); //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_PREF_DEPLOYMENT_DIR, "deploy"); //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_PREF_MODEL_DIR, "model"); //$NON-NLS-1$
		store.setDefault(CoreConstants.MTJ_PREF_RESOURCES_DIR, "res"); //$NON-NLS-1$
	}
}

