/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.core.ui.preferences.view;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.mtj.api.extension.AdminGuiProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ExtensionInfoDialog extends StatusDialog {
	private MtjExtension adminExtension;
	private boolean hasAdminGui = false;

    public ExtensionInfoDialog(Shell shell, String title, MtjExtension node){
		super(shell);
		adminExtension = node;
		setTitle(title);
	}

    public boolean hasAdminGui(){
		return hasAdminGui;
	}
	
    public void createContent(Composite _composite) {
		try {
			createDialogArea(_composite);
		} catch (Exception e) {
	   		MtjCoreUiPlugin.getDefault().displayError(getShell(),1,1,Messages.ExtensionInfoDialog_Error,"AdminGuiProvider.create",e); //$NON-NLS-1$
			e.printStackTrace();
		}
	}
	
 	protected Control createDialogArea(Composite parent){		
		Composite composite = (Composite) super.createDialogArea(parent);
		
		Control container = null;
		AdminGuiProvider adminGuiProvider = null;
		try {
			adminGuiProvider = MtjServices.getInstance().getCorrespondingAdminGuiProvider(adminExtension);
			
			if(adminGuiProvider != null){
				hasAdminGui = true;
				container = adminGuiProvider.create(composite, SWT.NONE);
				if(container == null){
					container = new Composite(composite, SWT.NONE);
				}
				return container;
			} else {
				hasAdminGui = false;
				return null;
			}
		} catch (MtjException ex) {
	    	MtjCoreUiPlugin.getDefault().displayError(getShell(),1,1,Messages.ExtensionInfoDialog_Error,"AdminGuiProvider.create",ex );  //$NON-NLS-1$
			ex.printStackTrace();
		}
		return null;
	}

	protected Control createButtonBar(Composite parent) {
		Control control = super.createButtonBar(parent);			
		return control;			
	}
}
